import dayswig_python

# set up enough to fake out part (a) and (b)
fake_charge = -1
def dt_charge(h):
    return fake_charge
def dt_setcharge(h, charge):
    global fake_charge
    fake_charge = charge

class FakeAtom:
    charge = -9

atom = FakeAtom()

# make sure I have the values I thought I would
assert fake_charge == -1
assert atom.charge == -9

execfile("attributes.py")

# make sure I changed those values
assert fake_charge == 1
assert atom.charge == 1

# Now override with the real test code
from dayswig_python import dt_charge, dt_setcharge, dt_symbol


mol = dayswig_python.dt_smilin("CC(=O)[O-]")

atom1 = Atom(2)  # should be a C with no charge
atom2 = Atom(5)  # should be an O with -1 charge

assert atom1.charge == 0
assert atom2.charge == -1

assert atom1.symbol == "C"
assert atom2.symbol == "O"

atom2.charge = 4
assert atom2.charge == 4

try:
    atom1.symbol = "Q"
except TypeError:
    pass
else:
    raise AssertionError, "should not be able to set symbol"

atom1.blah = "ABC"
assert "blah" in atom1.__dict__.keys()
assert atom1.blah == "ABC"
