# Fake the Daylight toolkit enough so the text examples work

# Test molecule is CC(=O)[O-]

class Atom:
    def __init__(self, symbol, charge):
        self.symbol = symbol
        self.charge = charge
        self.weight = 0
        self.bonds = []

class Bond:
    def __init__(self, atom1, atom2, bondtype):
        self.atoms = [atom1, atom2]
        self.bondtype = bondtype
        atom1.bonds.append(self)
        atom2.bonds.append(self)

class Molecule:
    def __init__(self, atoms, bonds):
        self.atoms = atoms
        self.bonds = bonds
        self.is_dealloced = 1
    def __del__(self):
        for atom in self.atoms:   # remove cycles
            del atom.bonds

C1 = Atom("C", 0)
C2 = Atom("C", 0)
O1 = Atom("O", 0)
O2 = Atom("O", -1)

molecule = Molecule( [C1, C2, O1, O2],
                     [Bond(C1, C2, 1),
                      Bond(C2, O1, 2),
                      Bond(C2, O2, 1),] )
ids = {}
reverse_ids = {}

obj_count = 0
def add_object(obj):
    global obj_count
    obj_count = obj_count + 1
    ids[obj_count] = obj
    reverse_ids[id(obj)] = obj_count

add_object(molecule)
for atom in molecule.atoms:
    add_object(atom)
for bond in molecule.bonds:
    add_object(bond)

def dt_smilin(s):
    assert s == "CC(=O)[O-]", "only understand CC(=O)[O-]"
    assert molecule.is_dealloced, "singleton object for testing purposes"
    molecule.is_dealloced = 0
    return reverse_ids[id(molecule)]

def dt_dealloc(h):
    assert h == 1, "cannot delete object %d" % h
    assert not molecule.is_dealloced, "already deleted"
    molecule.is_dealloced = 1
    return 1

def dt_charge(h):
    obj = ids[h]
    if isinstance(obj, Atom):
        return obj.charge
    return -1  # this is what the toolkit returns on error to dt_charge

def dt_setcharge(h, charge):
    obj = ids[h]
    if isinstance(obj, Atom):
        obj.charge = charge
        return 1
    return 0

def dt_weight(h):
    obj = ids[h]
    if isinstance(obj, Atom):
        return obj.weight
    return -1  # this is what the toolkit returns on error to dt_weight

def dt_setweight(h, weight):
    obj = ids[h]
    if isinstance(obj, Atom):
        obj.weight = weight
        return 1
    return 0


def dt_symbol(h):
    obj = ids[h]
    if isinstance(obj, Atom):
        return obj.symbol
    return ""  # this is what the toolkit returns on error to dt_symbol

def dt_typename(h):
    obj = ids[h]
    return str(obj.__class__)  # not the same as what the toolkit returns,
                               # but close enough

def dt_type(h):
    return len(dt_typename(h))  # again, not correct

def dt_stringvalue(h):
    obj = ids[h]
    return getattr(obj, "stringvalue", "")

def dt_setstringvalue(h, stringvalue):
    obj = ids[h]
    obj.stringvalue = stringvalue


TYP_ATOM = "TYP_ATOM"
TYP_ANY = "TYP_ANY"
class Stream:
    def __init__(self, data):
        self.data = data
        self.i = 0

def dt_stream(obj, stream_type):
    assert stream_type == TYP_ATOM
    assert obj == 1
    return Stream( [2, 3, 4, 5] ) # The atom ids

def dt_reset(stream):
    assert isinstance(stream, Stream)
    stream.i = 0

def dt_next(stream):
    assert isinstance(stream, Stream)
    if stream.i >= len(stream.data):
        return 0
    x = stream.data[stream.i]
    stream.i = stream.i + 1
    return x

def dt_count(obj, data_type):
    assert isinstance(obj, Stream)
    assert data_type in [TYP_ATOM, TYP_ANY]
    return len(obj.data)

