# Caption
#  A list-like class for forward iteration through toolkit streams.

class Iterator:
    def __init__(self, handle, converter = None):
        self.handle = handle
        self._i = 0
        self.converter = converter

    def __len__(self):
        return dt_count(self.handle, TYP_ANY)
    __nonzero__ = __len__

    def __getitem__(self, i):
        if i != self._i:
            raise IndexError, "forward iteration only"
        element = dt_next(self.handle)
        if not element:
            raise IndexError, "list index out of range"
        self._i = i + 1
        if self.converter:
             return self.converter(element)
        return element


    def next(self):
        try:
            return self.__getitem__(self._i)
        except IndexError:
            return None
