import dayswig_python

from dayswig_python import dt_type, dt_typename, dt_charge, dt_setcharge, \
     dt_weight, dt_setweight, dt_stringvalue, dt_setstringvalue, dt_symbol
 
execfile("table.py")

from dayswig_python import dt_count, dt_next, TYP_ANY, dt_reset

execfile("iterate.py")

mol = dayswig_python.dt_smilin("CC(=O)[O-]")
stream = dayswig_python.dt_stream(mol, dayswig_python.TYP_ATOM)

iterator = Iterator(stream)
assert len(iterator) == 4
if iterator:
    pass
else:
    raise AssertionError, "no data?"

charges = [0, 0, 0, -1]
i = 0
for atom in iterator:
    assert dt_charge(atom) == charges[i], i
    i = i + 1
dt_reset(stream)
assert i == 4

iterator = Iterator(stream, Atom)
names = ["C", "C", "O", "O"]
i = 0
for atom in iterator:
    assert atom.symbol == names[i]
    i = i + 1
assert i == 4

dt_reset(stream)
i = 0
while 1:
    x = iterator.next()
    assert x, "finished too early"
    if x.symbol == "O":
        assert i == 2
        break
    i = i + 1
while 1:
    x = iterator.next()
    if not x:
        break
    assert x.symbol == "O"

