# Caption

#  (a) Part of the dispatch table used in PyDaylight's base class.
#  (b) A derived class which adds atom-specific attributes.

# Part (a) <a name="a">

dayobject_properties = {
   "type": (dt_type, None),
   "typename": (dt_typename, None),
   "stringvalue": (dt_stringvalue, dt_setstringvalue),
}

class dayobject:
    __members__ = dayobject_properties.keys()
    _properties = dayobject_properties
    def __init__(self, handle):
        self.handle = handle
    def __int__(self):
        return int(self.handle)
    def __getattr__(self, name):
        get_set = self._properties.get(name, None)
        if get_set is None:
            raise AttributeError, name
        return get_set[0](self.handle)
    def __setattr__(self, name, val):
        get_set = self._properties.get(name, None)
        if get_set is None:
            self.__dict__[name] = val
        else:
            set = get_set[1]
            if set is None:
                raise TypeError, "readonly attribute"
            set(self.handle, val)

# Part (b) <a name="b">

atom_properties = dayobject_properties.copy()
atom_properties.update( {
    "charge": (dt_charge, dt_setcharge),
    "symbol": (dt_symbol, None),
    "weight": (dt_weight, dt_setweight),
})

class Atom(dayobject):
    __members__ = atom_properties.keys()
    _properties = atom_properties

