// copyright (C) 2000 by David Cox All Rights Reserved

#ifndef __lexan_h
#define __lexan_h


#include <string>
#include <istream>

class Token
{
public:

	enum TokenType {
		e_startComment,
		e_endComment,
		e_startTag,
		e_endTag,
		e_charData,
		e_closeTag,
		e_attribute,
		e_keyword,
		e_comment,
		e_equal,
		e_integer,
		e_float,
		e_name,
		e_string,
		e_none,
		e_eof,
		e_error
	};

	Token();
	Token(const Token &);
	~Token();
	Token & operator=(const Token &);

	TokenType Type();
	void Type(TokenType);

	std::string & String();
	void String(const std::string &);

	bool operator==(const Token &);
	bool operator!=(const Token &);

private:

	TokenType m_type;
	std::string m_string;

};


class Lexan
{
public:

	Lexan();

	Token NextToken(Token &);
	void GetCharData(Token &);
	
	Token NextToken(Token &, std::istream & in);
	void GetCharData(Token &, std::istream & in);

	void Error();
	int LineNumber();
	int ColNumber();

private:

	int m_lineNo;
	int m_colNo;

	int  GetChar(std::istream & in);
	void EatWhiteSpace(std::istream & in);
	void UnGetChar(int, std::istream & in);
	void GetQuotedString(Token &, int delim, std::istream & in);
	void GetName(Token &, int start, std::istream & in);
	void GetString(std::string & buffer, int delim, std::istream & in);
	void GetComment(Token &, std::istream & in);
	void GetKeyword(Token &, std::istream & in);

	bool IsNameChar(int);
};


#endif
