// copyright (C) 2000 by David Cox All Rights Reserved

#ifndef __parser_h
#define __parser_h

#include "lexan.h"
#include "tag.h"
#include <string>
#include <iostream>

class Parser
{
public:

	Parser();
	~Parser();

	void Translate(std::istream & f = std::cin);
	Tag * GetRoot();

private:

	Token m_lookahead;
	Token m_leftStartAngle;
	Token m_rightStartAngle;
	Token m_leftEndAngle;
	Token m_rightEndAngle;
	Token m_equal;

	Lexan m_lexan;
	Tag * m_root;
	std::istream * m_f;

	void GetTag(Tag * &);
	void StartTag(Tag *);
	void EndTag();
	void Content(Tag *);
	void TagName(std::string &);
	void AttributeList(Tag *);
	void Attribute(Tag *);

	void Match(Token &);
	void Match(Token &, Token::TokenType);
	void Error();
	void Eof();
};


#endif
