// copyright (C) 2000 by David Cox All Rights Reserved

#include "tag.h"
#include <memory.h>
#include <stdio.h>
#include <iostream>


int level = 0;


Attribute::Attribute()
{
}


Attribute::Attribute(const Attribute & attribute)
{
	m_name = attribute.m_name;
	m_value = attribute.m_value;
}


Attribute::~Attribute()
{
}


Attribute &Attribute::operator=(const Attribute & attribute)
{
	if (this == &attribute) return *this;

	m_name = attribute.m_name;
	m_value = attribute.m_value;

	return *this;
}


void Attribute::Name(const std::string & s)
{
	m_name = s;
}


std::string &Attribute::Name()
{
	return m_name;
}


void Attribute::Value(const std::string & s)
{
	m_value = s;
}


std::string &Attribute::Value()
{
	return m_value;
}

//************************************************************
Content::Content()
{
}


Content::Content(const Content & content)
{
	m_value = content.m_value;
}


Content::~Content()
{
}


Content &Content::operator=(const Content & content)
{
	if (this == &content) return *this;

	m_value = content.m_value;

	return *this;
}


void Content::Value(const std::string & s)
{
	m_value = s;
}


std::string &Content::Value()
{
	return m_value;
}


void Comment::Value(const std::string & s)
{
	m_value = std::string("<!--");
	m_value += s;
	m_value += std::string("-->");
}

//***********************************************************


Tag::Tag()
{
	m_child = 0;
	m_sibling = 0;
	m_parent = 0;
}


Tag::Tag(const std::string & name)
{
	m_child = 0;
	m_sibling = 0;
	m_name = name;
}


Tag::Tag(const Tag & tag)
{
	m_name = tag.m_name;
}


Tag::~Tag()
{
	delete m_sibling;
	delete m_child;
}


void Tag::Name(const std::string & name)
{
	m_name = name;
}


Tag &Tag::operator=(const Tag & tag)
{
	if (this == &tag) return *this;
	return *this;
}


void Tag::AddChild(Tag * tag)
{
	if (m_child) m_child->AddSibling(tag);
	else m_child = tag;
}


void Tag::AddSibling(Tag * tag)
{
	if (m_sibling) m_sibling->AddSibling(tag);
	else m_sibling = tag;
}


Tag * Tag::Child()
{
	return m_child;
}


Tag * Tag::Sibling()
{
	return m_sibling;
}


void Tag::InOrder()
{
	if (m_child) 
	{
		level++;
		m_child->InOrder();
		level--;
	}

	Visit(0);
	
	if (m_sibling)
	{
		m_sibling->InOrder();
	}
}


void Tag::PostOrder()
{
	if (m_child)
	{
		level++;
		m_child->PostOrder();
		level--;
	}

	if (m_sibling) m_sibling->PostOrder();

	Visit(0);
}


void Tag::PreOrder()
{
	Visit(0);

	if (m_child)
	{
		level++;
		m_child->PreOrder();
		level--;
	}

	if (m_sibling) m_sibling->PreOrder();
}


void Tag::PrintString(std::string & s)
{
	for (int i = 0; i < level; i++)
		std::cout << "\t";

	std::cout << "Tag String: " << s;
}


void Tag::PrintAttribute(std::string & name, std::string & value)
{
	for (int i = 0; i < level+1; i++)
		std::cout << "\t";

	std::cout << "attribute: " << name << "=" << value << std::endl;
}


void Tag::PrintContent(std::string & content)
{
	for (int i = 0; i < level+1; i++)
		std::cout << "\t";

	std::cout << "content: " << content << std::endl;
}


void Tag::PrintNewContent(std::string & content)
{
	for (int i = 0; i < level+1; i++)
		std::cout << "\t";

	std::cout << "New content: " << content << std::endl;
}


void Tag::Visit()
{
	PrintString(m_name);
	std::cout << std::endl;

	AttributeList::iterator li;
    for (li = m_alist.begin(); li != m_alist.end(); ++li)
	{
		PrintAttribute(li->Name(), li->Value());
	}

	ContentList::iterator ci;
	for (ci = m_clist.begin(); ci != m_clist.end(); ++ci)
	{
		PrintContent(ci->Value());
	}
}


void Tag::Visit(int level)
{
	// indent for effect
	for (int i = 0; i < level; i++)
		std::cout << "\t";

	// print the name of the tag followed by the level
	PrintString(m_name);
	std::cout << "\t" << level << std::endl;

	// print all the attributes
	AttributeList::iterator li;
    for (li = m_alist.begin(); li != m_alist.end(); ++li)
	{
		PrintAttribute(li->Name(), li->Value());
	}

	// print the content
	ContentList::iterator ci;
	for (ci = m_clist.begin(); ci != m_clist.end(); ++ci)
	{
		PrintContent(ci->Value());
	}
}


void Tag::AddAttrib(const std::string & name, const std::string & value)
{
	Attribute * a = new Attribute;
	a->Name(name);
	a->Value(value);
	m_alist.insert(m_alist.end(), *a);
}


void Tag::AddContent(const std::string & value)
{
	Content * b = new Content;
	b->Value(value);
	m_clist.insert(m_clist.end(), *b);
}


void Tag::AddComment(const std::string & value)
{
	Comment * b = new Comment;
	b->Value(value);
	m_clist.insert(m_clist.end(), *b);
}
