// copyright (C) 2000 by David Cox All Rights Reserved

#ifndef _tag_h
#define _tag_h


#include <list>
#include <string>
#include <stack>

class Attribute
{
public:

	Attribute();
	Attribute(const Attribute &);
	~Attribute();
	Attribute &operator=(const Attribute &);

	void Name(const std::string &);
	std::string &Name();

	void Value(const std::string &);
	std::string &Value();

	friend bool operator==(const Attribute &, const Attribute &);
	friend bool operator!=(const Attribute &, const Attribute &);

	friend bool operator<(const Attribute &, const Attribute &);
	friend bool operator>(const Attribute &, const Attribute &);

private:

	std::string m_name;
	std::string m_value;
};

bool operator==(const Attribute &, const Attribute &);
bool operator!=(const Attribute &, const Attribute &);

bool operator<(const Attribute &, const Attribute &);
bool operator>(const Attribute &, const Attribute &);

typedef std::list<Attribute> AttributeList;


class Content
{
public:

	Content();
	Content(const Content &);
	~Content();
	Content &operator=(const Content &);

	virtual void Value(const std::string &);
	std::string &Value();

	friend bool operator==(const Content &, const Content &);
	friend bool operator!=(const Content &, const Content &);

	friend bool operator<(const Content &, const Content &);
	friend bool operator>(const Content &, const Content &);

protected:

	std::string m_value;
};


class Comment : public Content
{
public:

	virtual void Value(const std::string &);
};


bool operator==(const Content &, const Content &);
bool operator!=(const Content &, const Content &);

bool operator<(const Content &, const Content &);
bool operator>(const Content &, const Content &);

typedef std::list<Content> ContentList;


class Tag
{
public:

	Tag();
	Tag(const std::string &);
	Tag(const Tag &);
	~Tag();
	Tag &operator=(const Tag &);

	void Name(const std::string &);
	void AddAttrib(const std::string & name, const std::string & value);
	void AddContent(const std::string & value);
	void AddComment(const std::string & value);

	void AddChild(Tag *);
	void AddSibling(Tag *);

	Tag * Child();
	Tag * Sibling();

	// standard recursive traversals
	void InOrder();
	void PostOrder();
	void PreOrder();

	// visit functions
	void Visit();
	void Visit(int level);

private:

	std::string m_name;
	AttributeList m_alist;
	ContentList m_clist;
	
	Tag * m_sibling;
	Tag * m_child;
	Tag * m_parent;

	void PrintString(std::string & s);
	void PrintContent(std::string & content);
	void PrintNewContent(std::string & content);
	void PrintAttribute(std::string & name, std::string & value);
};


typedef std::stack<Tag *> TagStack;


#endif