// copyright (C) 2000 by David Cox All Rights Reserved

#include "TagIterator.h"


TagIterator::TagIterator(Tag * root)
{
	m_root = root;
	m_level = 0;
}


Tag * TagIterator::Begin()
{
	// We will traverse the tree preorder
	// visit the root first
	// go to left subtree
	// go to right subtree

	m_cur = m_root;
	return m_cur;
}


Tag * TagIterator::Next()
{
	if (m_cur == 0)
		return m_cur;

	// use stack to keep track of where we've been
	// go on to child (left tree)
	m_stack.push(m_cur);		
	m_cur = m_cur->Child();		
	m_level++;

	while (true)
	{
		if (m_cur != 0)
		{
			// m_cur points to a tag
			// so break and return it
			break;
		}

		else
		{
			// no where to go
			// backtrack if we can
			if (!m_stack.empty())
			{
				// There are tags on the stack that we have
				// already visited.  We can now visit the sibling
				// of the top (that is last visited) tag.

				Tag * m_top = m_stack.top();
				m_stack.pop();
				m_level--;
				m_cur = m_top->Sibling();

				// Notice that we stay in the loop. If Sibling()
				// returned 0, we will be back in this section of
				// code and will pop the stack again allowing us
				// to travel back up the tree.  We do this until
				// we find a tag with a right subtree.
			}
			else
			{
				// The stack was empty.  We are done.
				m_cur = 0;
				break;
			}
		}
	}
	return m_cur;
}


int TagIterator::Level()
{
	// m_level keeps track of how far down the tree we are while
	// traversing the tree
	return m_level;
}
