// copyright (C) 2000 by David Cox All Rights Reserved

#include "parser.h"
#include "tagiterator.h"
#include <fstream>

void main(int argc, char *argv[])
{
	std::ifstream xmlFile(argv[1]);

	Parser p;
	p.Translate(xmlFile);

	Tag * root = p.GetRoot();

	TagIterator ti(root);

	Tag * next = ti.Begin();

	while (next)
	{
		next->Visit(ti.Level());
		next = ti.Next();
	}

	exit(0);
}
