
import java.net.*;
import java.io.*;
import javax.net.ssl.*;
import javax.security.cert.X509Certificate;
import com.sun.net.ssl.*;
import java.security.KeyStore;

public class client {

	private static int DEFAULT_PORT = 5100;

	public static void main( String[] args ) throws Exception {
	
		String type = args[0];
		String host = args[1];
		String cc = args[2];
		String amnt = args[3];

		Socket socket = null;

		if ( type.equals( "TLS" ) ) {
			SSLSocketFactory factory = null;

			SSLContext ctx = SSLContext.getInstance( "TLS" );
			KeyManagerFactory kmf = KeyManagerFactory.getInstance( "SunX509" );
			KeyStore ks = KeyStore.getInstance( "JKS") ;

			char[] passphrase = "passphrase".toCharArray();
			ks.load(new FileInputStream("testkeys"), passphrase);

			kmf.init(ks, passphrase);

			TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
			tmf.init( ks );

			ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);

			factory = ctx.getSocketFactory();

			socket = factory.createSocket(host, DEFAULT_PORT);

		} else {

			socket = new Socket( host, DEFAULT_PORT );

		} // else

		sendData( socket, cc, amnt );

	} // main

	static void sendData( Socket server, String cc, String amnt ) {

	
		try { 
			BufferedWriter out = new BufferedWriter( new OutputStreamWriter( server.getOutputStream() ) );
			BufferedReader in = new BufferedReader( new InputStreamReader( server.getInputStream() ) );

			boolean success = false;

			String s = in.readLine();

			if ( s.equals( "HELO CC-SERVER" ) ) {
				System.out.println( "Connected to server." );

				println( out, "HELO CC-CLIENT" );

				s = in.readLine();
				if ( s.equals( "READY" ) ) {

					System.out.println( "Server ready." );

					println( out, cc + "\t" + amnt );

					s = in.readLine();
					if ( s.equals( "OK" ) ) {
						success = true;
					} // if

				} // if
			} // if

			if ( success ) 
				System.out.println( "Data sent." );
			else
				System.out.println( "Protocal error. -- " + s );

			server.close();
		
		} catch ( Exception e ) {

			System.out.println( "Error: " + e.getMessage() );
			e.printStackTrace();

		} // catch

	} // send data


	static void println( BufferedWriter bw, String s ) throws IOException {

		bw.write( s );
		bw.newLine();
		bw.flush();

	} // println

}

