
import java.io.*;
import java.net.*;
import java.security.KeyStore;
import javax.net.*;
import javax.net.ssl.*;
import javax.security.cert.X509Certificate;
import com.sun.net.ssl.*;

public class server {

	private static int DEFAULT_PORT = 5100;


	public static void main(String args[]) {

		String type = "plain";
		if ( args.length > 0 ) {
			type = args[0];
		} // if

		try {

			ServerSocketFactory ssf = server.createServerSocketFactory( type );

			ServerSocket ss = ssf.createServerSocket( DEFAULT_PORT );

			if ( type.equals( "TLS" ) ) 
				((SSLServerSocket)ss).setNeedClientAuth( true );

			acceptConnections( ss );

		} catch (IOException e) {

			System.out.println( "Error: " + e.getMessage() );
			e.printStackTrace();

		} // try

	} // main

	private static ServerSocketFactory createServerSocketFactory( String type ) {

		if ( type.equals( "TLS" ) ) {

			SSLServerSocketFactory ssf = null;
			try {

				// set up key manager to do server authentication
				KeyManagerFactory kmf = KeyManagerFactory.getInstance( "SunX509" );
				KeyStore ks = KeyStore.getInstance( "JKS" );
		
				char[] passphrase = "passphrase".toCharArray();

				ks.load(new FileInputStream("testkeys"), passphrase);
				kmf.init(ks, passphrase);

				TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
				tmf.init( ks );
		
				SSLContext ctx = SSLContext.getInstance( "TLS" );
				ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);

				ssf = ctx.getServerSocketFactory();
				
				return ssf;
		
			} catch (Exception e) {

				System.out.println( "Error: " + e.getMessage() );
				e.printStackTrace();
		
			} // try

		} else {

			return ServerSocketFactory.getDefault();
		
		} // if

		return null;

	} // createServerSocketFactory


	static void acceptConnections( ServerSocket server ) {

		Socket socket = null;

		while( true ) {

			// accept a connection
			try {
			
				socket = server.accept();

			} catch (IOException e) {

				System.out.println("Error: " + e.getMessage());
				e.printStackTrace();
		
				return;

			} // catch

			// create a new thread to accept the next connection
			ClientProcessor cp = new ClientProcessor( socket );
			(new Thread( cp )).start();
	
		} // while

	} // run


} // server

class ClientProcessor implements Runnable {

	Socket socket = null;

	ClientProcessor( Socket client ) {
	
		socket = client;

	} // constructor

	public void run() {

		try {
		
			BufferedWriter out = new BufferedWriter( new OutputStreamWriter( socket.getOutputStream() ) );
			BufferedReader in = new BufferedReader( new InputStreamReader( socket.getInputStream() ) );

			println( out, "HELO CC-SERVER" );

			String s = in.readLine();
			if ( s.equals( "HELO CC-CLIENT" ) ) {

				System.out.println( "Client connected." );
				
				println( out, "READY" );

				s = in.readLine();
				writeTransaction( s );

				System.out.println( "Credit card authorized." );

				println( out, "OK" );

			} else {
				println( out, "IHATEYOU" );
			} // else

		} catch ( Exception e ) {

			System.out.println("Error: " + e.getMessage());
			e.printStackTrace();

		} // catch

		try {
			socket.close();
		} catch ( Exception ex ) {}

	} // run

	void writeTransaction( String s ) throws IOException {

		FileWriter fw = new FileWriter( "transactions.log", true );
		PrintWriter out = new PrintWriter( fw, true );

		out.println( s );
		out.flush();
		out.close();
		fw.close();

	} // writeTransaction

	static void println( BufferedWriter bw, String s ) throws IOException {

		bw.write( s );
		bw.newLine();
		bw.flush();

	} // println

} // ClientProcessor

