unit filterform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, MSSAXParser;

type
  TfrmFilter = class(TForm)
    SXP: TSAXParser;
    Memo1: TMemo;
    procedure SXPStartElement(const NamespaceURI, Localname,
      QName: String; const Attributes: TSXPAttributeList);
    procedure SXPEndElement(const NamespaceURI, Localname,
      QName: String);
    procedure SXPCharacters(const Chars: String);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    bWanted: boolean;
    strElement: string;
  end;

var
  frmFilter: TfrmFilter;

implementation

{$R *.DFM}

procedure TfrmFilter.SXPStartElement(const NamespaceURI, Localname,
  QName: String; const Attributes: TSXPAttributeList);
var
  attr: TSXPAttribute;
begin
  if bWanted then begin
    strElement := LocalName;
    exit;
  end;
  if CompareText(Localname, 'book') <> 0 then exit;
  if not Assigned (Attributes) then exit;
  attr := Attributes.GetItem('genre');
  if (attr = Nil) or (CompareText(attr.Value, 'fiction') <> 0) then exit;
  attr := Attributes.GetItem('in_stock');
  if (attr = Nil) or (CompareText(attr.Value, 'yes') <> 0) then exit;
  bWanted := true;
end;



procedure TfrmFilter.SXPEndElement(const NamespaceURI, Localname,
  QName: String);
begin
  if CompareText(LocalName, 'book') = 0 then begin
    if bWanted then
      Memo1.Lines.Add('--------------------------------------------');
    bWanted := false;
  end;
end;

procedure TfrmFilter.SXPCharacters(const Chars: String);
begin
  if bWanted then
    if Trim(Chars) <> '' then
      Memo1.Lines.Add(Format('%-20s %s', [strElement, Chars]));
end;

procedure TfrmFilter.FormCreate(Sender: TObject);
begin
  Memo1.Lines.Add('Fiction books currently in stock :');
  Memo1.Lines.Add('==================================');
  SXP.Parse;
end;

end.
