/*+---------------------------------------------------------------------+*/
/*                          F U J I T S U                              */
/*              M i k r o e l e k t r o n i k   G m b H                */
/*                                                                     */
/*  Filename:	     ADC.c						*/
/*  Description:    AD-Converter Testprogram, Polling Version		*/
/*		     (MB89630-EVAKIT with DemoExtensionBoard)           */
/*		     (Due to ESC-Sequences ANSI Terminal needed e.g. MT)*/
/*  Series:         MB89630                                            */
/*  Version:        V01.00                                             */
/*  Design:         Edmund Bendels 27.10.95                            */
/*+---------------------------------------------------------------------+*/
#include <MB89630.H>		  /* define processor depended information */
#include <EVABIOS.H>

typedef const struct { const char *pStr;} PCSTRS;
const char InitMsg[] =  " MB89630 A/D Converter Test Program V 1.0\n"
			"           (Polling Version)\n\n";
const char ADCmsg[] = "[32m A/D : ";
const char LsChar[] = "__";
PCSTRS  BarCol[] = { "[33mA", "[34mB", "[35mC", "[36mD" };

BYTE dyDVAR; direct BYTE dyDIRVAR;
BYTE dyDINT = 0x12; direct BYTE dyDIRINIT = 0x34;



direct WORD ADvalue;

/*+-------------------------------------+*/
/*	Dislay AD-Value			*/
/*+-------------------------------------+*/
void DisplayValue(int ADword)
{
  BYTE i, AD9b8, AD7b2, AD1b0;
	  /*--- print HexValue ---*/
	  putch(13);
          printHexByte(SYCC);		/* Print CPU Speed */
	  puts(ADCmsg);			/* Print String on Terminal */
          printHexWord(ADword);		/* Print A/D Value */
	  putch(' ');
	  /*--- print Bar-Diagramm of ADvalue */
	  AD9b8 = (ADword >> 8) & 0x03;
	  AD7b2 = (ADword >> 2) & 0x3F;
	  AD1b0 = ADword & 0x03;
	  puts(BarCol[AD9b8].pStr);	/* ESC-Sequence for Bar Color */
	  for (i=0;i<AD7b2;i++) {
	    putch('_'); }
	  putch(LsChar[AD1b0]);
	  for (i=AD7b2;i<63;i++) {
	    putch('_'); }
}

/*+-------------------------------------+*/
/*	Main Program			*/
/*+-------------------------------------+*/
void main ()
{
	puts(InitMsg);
/*	SYCC = 0x07;	/* (3) Highest Main Clock Speed (OK) */
/*	SYCC = 0x06;	/* (2)				(OK) */
/*	SYCC = 0x05;	/* (1) 				(OK) */
	SYCC = 0x04;	/* (0) Lowest Main Clock Speed	(OK) */


	ADC1 = 0x70;	/* Select Channel 7 (POTI-Output) */
/*	ADC1 = 0x60;	/* Select Channel 6 (KEY-Matrix) */
	ADC2 = 0x01;	/* Init: (Int.Dis, Intern.Clk, No AD-Trig)*/
	do {


	  AD   = 1; 	/* AD-Software Trigger (using AD-Start Bit) */
          while (ADMV) ;	/* Wait while Conversion in Progress */
	  ADvalue = ADDx;	/* Read A/D Register (16-bit) */
	  DisplayValue(ADvalue);
        } while (1);
}
