/*ͻ*/
/*                          F U J I T S U                              */
/*              M i k r o e l e k t r o n i k   G m b H                */
/*                                                                     */
/*  Filename:	     ADCI.c						*/
/*  Description:    A/D Testprogram, (IntTrig) InterruptDriven Version */
/*		     (MB89630-EVAKIT with DemoExtensionBoard)           */
/*		     (Due to ESC-Sequences ANSI Terminal needed e.g. MT)*/
/*  Series:         MB89630                                            */
/*  Version:        V01.00                                             */
/*  Design:         Edmund Bendels 02.11.95                            */
/*ͼ*/
#include <MB89630.H>		  /* define processor depended information */
#include <INT89630.H>
#include <EVABIOS.H>
typedef const struct { const char *pStr;} PCSTRS;
const char InitMsg[] =  " MB89630 A/D Converter Test Program V 1.0\n"
			"     (Interrupt Driven Version)\n\n";
const char ADCmsg[]  = "[32m A/D : ";
const char LsChar[] = "";
PCSTRS  BarCol[] = { "[33mA", "[34mB", "[35mC", "[36mD" };

BYTE dyDVAR; direct BYTE dyDIRVAR;
BYTE dyDINT = 0x12; direct BYTE dyDIRINIT = 0x34;

direct BYTE IntCnt;
direct BYTE newAD;
direct WORD ADvalue;

/*ͻ*/
/*	Dislay AD-Value			*/
/*ͼ*/
void DisplayValue(int ADword)
{
  BYTE i, AD9b8, AD7b2, AD1b0;
	  /*--- print HexValue ---*/
	  putch(13);
          printHexByte(IntCnt);		/* Print Interrupt Counter */
	  puts(ADCmsg);			/* Print String on Terminal */
          printHexWord(ADword);		/* Print A/D Value */
	  putch(' ');
	  /*--- print Bar-Diagramm of ADvalue */
	  AD9b8 = (ADword >> 8) & 0x03;
	  AD7b2 = (ADword >> 2) & 0x3F;
	  AD1b0 = ADword & 0x03;
	  puts(BarCol[AD9b8].pStr);
	  for (i=0;i<AD7b2;i++) {
	    putch(''); }
	  putch(LsChar[AD1b0]);
	  for (i=AD7b2;i<63;i++) {
	    putch(''); }
}

/*ͻ*/
/*	Main Program			*/
/*ͼ*/
void main ()
{
	puts(InitMsg);
	SYCC = 0x07; /* (3) High Main Clock Speed */
/*	SYCC = 0x06; /* (2) */
/*	SYCC = 0x05; /* (1) 			 (DOES NOT WORK with EXT=1!) */
/*	SYCC = 0x04; /* (0) Low Main Clock Speed (DOES NOT WORK with EXT=1!) */
	ILR3 = 0xF3;	/* Set AD-Interrupt Level */
	ENABLE;		/* Enable Interrupts */
	ADC1 = 0x70;	/* Select Channel 7 (POTI-Output) */
/*	ADC1 = 0x60;	/* Select Channel 6 (KEY-Matrix) */
	ADC2 = 0x09;	/* Init: (Int.Enab, Intern.Clk, No AD-Trig)*/
	do {
	  IntCnt = 0;	/* Clear Counter Variable */
	  EXT  = 1;	/* AD-Auto Tirgger (using 2^8 division of main-clock)*/
/*	  AD   = 1; 	/* AD-Software Trigger (using AD-Start Bit) */
          while (!newAD) ;	/* Wait until ISR has read out Value */
	  newAD = 0;		/* Clear global Flag */
	  DisplayValue(ADvalue);
	} while (1);
}

/*ͻ*/
/*                                                                     */
/*ͼ*/
#pragma interrupt
#pragma save_reg

void ADCINT9()
{
	EXT  = 0;	/* Cancel Auto Mode (make sure AD value is not read */
			/* next time while conversion is already in progress */
			/* due to long "puts()" procedure (interrupt disabled)*/

        while (ADMV) { IntCnt++; } /* Wait Conv. really finished ! (if EXT)*/
	ADvalue = ADDx;		/* read and store AD-converter value */
	newAD = 1;		/* set global flag */
	ADI = 0;		/* Clear Interrupt Source */
}

void WATCHINT11() {}
void TBCINT10() {}
void UART_T_INT8() {}
void UART_R_INT7() {}
void TC16INT6() {}
void PWCINT5() {}
void PWM2INT4() {}
void PWM1INT3() {}
void SIOINT2() {}
void EXINT1() {}
void EXINT0() {}

#pragma nosave_reg
#pragma nointerrupt

