/*ͻ*/
/*                          F U J I T S U                              */
/*              M i k r o e l e k t r o n i k   G m b H                */
/*                                                                     */
/*  Filename:	     SENS.c						*/
/*  Description:    A/D SensMode Testprogram, (ExtTrig)InterruptDriven */
/*		     (MB89630-EVAKIT with DemoExtensionBoard)           */
/*                                                                     */
/*  Series:         MB89630                                            */
/*  Version:        V01.00                                             */
/*  Design:         Edmund Bendels 02.11.95                            */
/*ͼ*/
#include <MB89630.H>		  /* define processor depended information */
#include <INT89630.H>
#include <EVABIOS.H>
#define SUBSLEEP

typedef const struct { const char *pStr;} PCSTRS;
const char InitMsg[] =  " MB89630 A/D SensMode Test Program V 1.0\n"
			"   (ExtTrig. Interrupt Driven Version)\n\n";
const char HitMsg[]  =  "\n < Sens Activated ! >";

BYTE dyDVAR; direct BYTE dyDIRVAR;
BYTE dyDINT = 0x12; direct BYTE dyDIRINIT = 0x34;

direct BYTE ActSens, IntCnt;

/*ͻ*/
/*	Main Program			*/
/*ͼ*/
void main ()
{
	puts(InitMsg);
	SYCC = 0x07; /* (3) High Main Clock Speed */
/*	SYCC = 0x06; /* (2)			  */
/*	SYCC = 0x05; /* (1) 			  */
/*	SYCC = 0x04; /* (0) Low Main Clock Speed  */

	ILR3 = 0xF3;	/* Set AD-Interrupt Level */
	ENABLE;		/* Enable Interrupts */

	ADDx = 0x0200;	/* Specify Trigger Level */
	ADC1 = 0x70;	/* Select Channel 7 (POTI-Output) */
/*	ADC1 = 0x60;	/* Select Channel 6 (KEY-Matrix) */

/*	ADC2 = 0x0D;	/* Init: (Int.Ena, Int.Clock, Sens, No AD-Trig)*/
	ADC2 = 0x1D;	/* Init: (Int.Ena, P50/ADST, Sens, No AD-Trig)*/

	do {
	  ActSens = 0;	/* Clear Counter Variable */
	  EXT  = 1;	/* AD-Auto Tirgger (using P50/ADST InputSignal)*/

	  /*----- Test if AD-Interrupt can wake-up from SubSleepMode ----*/
#ifdef SUBSLEEP
	  SCS = 0;		/* Switch to Sub-Run Mode */
	  SLP = 1;		/* Activate SubSleepMode */
	  asm { " NOP" };	/* just for fun */
	  SCS = 1;		/* Back to Main-Clock again */
#endif

          while (!ActSens) ;	/* Wait until ISR was Activated */
	  ActSens = 0;		/* Clear global Flag */
	  puts(HitMsg);
	} while (1);
}

/*ͻ*/
/*                                                                     */
/*ͼ*/
#pragma interrupt
#pragma save_reg

void ADCINT9()
{
	EXT  = 0;	/* Cancel Auto Mode (make sure AD value is not read */
			/* next time while conversion is already in progress */
			/* due to long "puts()" procedure (interrupt disabled)*/

        while (ADMV) { IntCnt++; } /* Wait until Conversion really finished !*/
	ActSens = 1;		/* set global flag */
	ADI = 0;		/* Clear Interrupt Source */
}

void WATCHINT11() {}
void TBCINT10() {}
void UART_T_INT8() {}
void UART_R_INT7() {}
void TC16INT6() {}
void PWCINT5() {}
void PWM2INT4() {}
void PWM1INT3() {}
void SIOINT2() {}
void EXINT1() {}
void EXINT0() {}

#pragma nosave_reg
#pragma nointerrupt

