/*---------------------------------------------------------------------*/
/*                          F U J I T S U                              */
/*                                                                     */
/*              M i k r o e l e k t r o n i k   G m b H                */
/*                                                                     */
/*                                                                     */
/*  Filename:       COMM.C					       */
/*  Description:    Communication Demo for MB89630-UART. Can be used   */
/*                  with Starterkit_8 EVA-Board (MB89630, 10MHz osc)   */
/*                  baud rate can be set to 300...38400 (8,N,2)        */
/*                  using the dedicated baudrate-generator or a timer. */
/*                                                                     */
/*                  Puts a "hello"-message to a connected host (PC etc)*/
/*                  and then waits for characters and echoes them back.*/
/*                                                                     */
/*                  For RS232 external hardware(e.g.MAX232) via Port 4 */
/*                  is required ! (Pin 41 and 42 are used as RX/TX)    */
/*                  Can be used with InCircuitEmulator                 */
/*  Series:         MB89630                                            */
/*  Version:        V02.00                                             */
/*  Design:         Markus Mierse 				       */
/*  Date:           14.01.97 change : 11.9.97            	       */
/*---------------------------------------------------------------------*/


#include <TYPEDEFS.H>		/* Usefull Type Definitions */
#include <MB89630.H>    	/* register definitions for 630-family  */
#include <INT89630.H>   	/* interrupt definitions for 630-family	*/

direct BYTE DirVarByte;		/* DIRVAR  (initialized to 0) */
direct BYTE DirInitByte = 5;	/* DIRINIT,DIRCONST (DIRCONST => DIRINIT) */
BYTE VarByte;			/* DVAR    (initialized to 0) */
BYTE InitByte = 0;		/* DINIT, DCONST (DCONSt=>DINIT) */
const int consdummy = 0;	/* definition to avoid linker warning */

BYTE *LED1 = 0x0AE2;		/* Pointers to the LED memory maped I/O */
BYTE *LED2 = 0x0AE3;

unsigned char revchar;		/* Received Char */
long int w;

#define dedi 0			/* 1 : use dedicated baudrate gen */
				/* 0 : use timer to generate baudrate */

/**/

/* Prototypes */

void initrs232(void);
unsigned char getch (void);
void putch (BYTE);
void puts (BYTE *Name2);


/**/

/* Main Module */

void main (void)
{
  SYCC = 0x07;				/* main clock = HiSpeed (ext. f=10MHz)*/

  initrs232();				/* init UART */
  ILR2 = 0x7F;				/* allow receive Interrupt (INT7) */
  ENABLE;				/* enable Interrupts */

  puts("\13\10");			/* put a message to host */
  puts("Hello World !\13\10");
  puts("I am the 8-bit Starterkit.\13\10");

  *LED1 = 0;
  *LED2 = 0; 

  while(1);				/* main loop (wait for receive Int) */
}


/**/
/* Procedures for ext. UART communication (connected to Port 4)	       */
/**/


void initrs232(void)		/* this routine initializes the UART */
{
 DDR4 = 0x08;			/* Port 4 Pin 3 output */
 IO_PDR4.BIT.D3 = 0;   		/* clear output bit */

 SSD = 0x02C;			/* Serial Status = Empty, rec-int, Port4 */
 SMC = 0x059;			/* Serial Mode Control =  no parity, */
				/*  2 Stopbits, 8 Databits, async, enable */

		/* Selection of baudrate (dedicated or timer generated) : */

#if dedi 
		/* normally, the dedicated baudrate generator is used : */

 SRC = 0x039;		/* dedicated baudrate generator settings :   */
			/* 0x38 : dedicated baudrate gen = 9600 baud */
			/* 0x39 : dedicated baudrate gen = 4800 baud */
			/* 0x3A : dedicated baudrate gen = 2400 baud */
			/* 0x3B : dedicated baudrate gen = 1200 baud */
			/* 0x3C : dedicated baudrate gen =  600 baud */
			/* 0x3D : dedicated baudrate gen =  300 baud */

#else
		/* but also a timer can be used to generate the baudrate : */

 COMR1 = 0x03;			/* timer compare register : */
 				/* 0x07 : timer baudrate =  9600  (9765) bd */
 				/* 0x03 : timer baudrate = 19200 (19531) bd */
 				/* 0x01 : timer baudrate = 38400 (39062) bd */

 SRC = 0x08;			/* Serial Rate Control = timer (main clock) */
 CNTR1 = 0;			/* timer mode, SC=1 cycle */
 CNTR2 = 0x80;			/* enable timer 1 */

#endif

 revchar = SSD;		/* dummy read (in case there was something send) */
 revchar = SIDR;
     
}

unsigned char getch (void)	/* Procedure to get a character from UART */
{
	BYTE c;
	while (IO_SSD.BIT.D7  == 0);	/* wait until char is received */
	c = SIDR;			/* read char */
	return (c);			/* return the received char */
}


void putch (BYTE c)		/* Procedure to put a character to UART */
{
	while (IO_SSD.BIT.D5 == 0) ;  	/* wait until Puffer empty */
	SODR = c;			/* send character */
}


void puts (BYTE *Name2)		/* Puts a String to UART */
{
 unsigned char c;
 BYTE b;	
 int i;

 for (i=0; i<strlen(Name2); i++) 	/* go through string */
  {
	c=(Name2[i]);			/* pick char */
	putch (c);			/* send it out */
  }

  
}


/**/
/* Interrupt Service Routines 					       */
/**/


#pragma interrupt
#pragma save_reg
 void WATCHINT11(){}
 void TBCINT10(){}
 void ADCINT9(){}
 void UART_T_INT8(){}

 void UART_R_INT7()	/* Receive Interrupt Service Routine for UART : */
{
 *LED1 = 0;		/* flash LEDs */
 *LED2 = 0; 
 revchar = getch();	/* get the received character */
 putch(revchar);	/* and echo it back */
 *LED1 = 1;
 *LED2 = 1; 
}

 void TC16INT6(){}
 void PWCINT5(){}
 void PWM2INT4(){}
 void PWM1INT3(){}
 void SIOINT2(){}
 void EXINT1(){}
 void EXINT0(){}
#pragma nointerrupt
#pragma nosave_reg


