$CP
;*****************************************
;   Sample program for initialization	 *
;*****************************************
		NAME	init
		TITLE	init

;---------------------------------------
; Start symbol definition for data area
;---------------------------------------
DVAR		DSEG
		PUBLIC	DVAR_START
DVAR_START:
DVAR		ENDS

DINIT		DSEG
		PUBLIC	DINIT_START
DINIT_START:
DINIT		ENDS

;------------------------------------------------
; Start symbol definition for initial value area
;------------------------------------------------
DCONST		DSEG	PUBLIC,ROM
		PUBLIC	DCONST_START
DCONST_START:
DCONST		ENDS

DIRCONST	DSEG	PUBLIC,ROM
		PUBLIC	DIRCONST_START
DIRCONST_START:
DIRCONST	ENDS

;----------------------------------------------------
; Start symbol definition for direct addressing area
;----------------------------------------------------
DIRVAR		DIRSEG
		PUBLIC	DIRVAR_START
DIRVAR_START:
DIRVAR		ENDS

DIRINIT		DIRSEG
		PUBLIC	DIRINIT_START
DIRINIT_START:
DIRINIT		ENDS

;------------------------------------------------
; Stack area and stack top definition
;------------------------------------------------
		SSEG
		PUBLIC	stack_top
		RB	126
stack_top	RB	2
		ENDS

;------------------------------------------------
; CPU register initialization
;------------------------------------------------
CSEG		CSEG
		PUBLIC	start
		PUBLIC	end
		EXTRN	_main
		EXTRN	LMEMTOMEM
		EXTRN	LMEMCLEAR
start:
		MOVW	A,#stack_top		; Stack top
		MOVW	SP,A

		

;------------------------------------------------
; Copy from initial value area to data area
;------------------------------------------------
		MOVW	A,#DINIT_START
		MOVW	A,#segsize(DCONST)
		MOVW	EP,#DCONST_START
		CALL	LMEMTOMEM

		MOVW	A,#DIRINIT_START
		MOVW	A,#segsize(DIRCONST)
		MOVW	EP,#DIRCONST_START
		CALL	LMEMTOMEM

;------------------------------------------------
; Clear zero for data area
;------------------------------------------------
		MOVW	A,#DVAR_START
		MOVW	A,#segsize(DVAR)
		CALL	LMEMCLEAR

		MOVW	A,#DIRVAR_START
		MOVW	A,#segsize(DIRVAR)
		CALL	LMEMCLEAR

;---------------------------------------------
; Call user function
;---------------------------------------------
		CALL	_main			; Start main function

end:		JMP	end			; Loop

CSEG		ENDS
		END	