$lo cy xr cp
;ͻ
;                          F U J I T S U                               
;                                                                      
;              M i k r o e l e k t r o n i k   G m b H                 
;                                                                      
;  Filename:	UAI.asm							
;  Topic:	"MB89630 UART Test Program"				
;		(Dedicated BaudRateGen as Clock Source)			
;		(Interrupt Driven Version)				
;  Series:	MB89630 (ready to run on 630 EVAKIT)			
;  Version:	V00.00							
;  Design:	Edmund Bendels 01.02.96					
;  Change:                                                             
;ͼ

	NAME   "UAI"			; module name

 &SET DebugFunctions 0			; Flag: Include Debug Functions
 &INCLUDE "c:\FJ_8L_3\Include\eBIOS.inc"

;-----------------------------------------
;-----------------------------------------
PDR1	EQU  002h
DDR1	EQU  003h

SYCC	EQU  0007h			; System Clock Control

PDR4	EQU  00Fh
DDR4	EQU  010h

CNTR1	EQU  028h
CNTR2	EQU  029h
CNTR3	EQU  02Ah
COMR1	EQU  02Bh
COMR2	EQU  02Ch

SMC	EQU  02Dh
SRC	EQU  02Eh
SSD	EQU  02Fh
SIDR	EQU  030h
SODR	EQU  030h

ILR1	EQU  07Ch
ILR2	EQU  07Dh
ILR3	EQU  07Eh

;-----------------------------------------
;-----------------------------------------
DIRVAR	DIRSEG
IntNum	RB  1		; for Test Purpose
DIRVAR	ENDS

;-----------------------------------------
;-----------------------------------------
DVAR	DSEG
nTxStr	RB  1		; number of Bytes to transmitt
pTxStr	DW  1		; pointer to transmitt string
DVAR	ENDS


CCONST		CSEG
;-----------------------------------------
;-----------------------------------------
IniMel	DB 13,10,"[2J MB89630 UART Test Program",13,10
	DB "(DedicatedBaudRate, Interrupt Driven)",13,10,0
TxStr1	DB 13,10,"Tx Test String (1)",13,10,0
TxStr2	DB "Tx Test String (2)",13,10,0
RecMel	DB 13,10,"Executing Echo Loop",13,10,0

;-----------------------------------------
;--	Some Symbol Info for Monitor	--
;-----------------------------------------
SymTab: DB "SymTab:",0          ; Symbol Table Header
	DB LabL1-LabS1,0	; Length of 1st Symbol, dummy byte
LabS1	DB "Reset"              ; Symbol Name
LabL1	DW Reset
	DB LabL2-LabS2,0
LabS2	DB "main"
LabL2	DW main
	DB LabL3-LabS3,0
LabS3	DB "Stop"
LabL3	DW Stop

	DB LabL4-LabS4,0
LabS4	DB "SMC"
LabL4	DW SMC
	DB LabL5-LabS5,0
LabS5	DB "SRC"
LabL5	DW SRC
	DB LabL6-LabS6,0
LabS6	DB "SSD"
LabL6	DW SSD
	DB LabL7-LabS7,0
LabS7	DB "TxStrUART"
LabL7	DW TxStrUART
	DB LabL8-LabS8,0
LabS8	DB "STRLEN"
LabL8	DW STRLEN
	DB LabL9-LabS9,0
LabS9	DB "IntUartTx"
LabL9	DW IntUartTx

        DB  00			; End of Symbol Table
        DB  01			; 1 BreakPoint
        DW  Stop
CCONST	ENDS

;-----------------------------------------
;-----------------------------------------
CSEG	CSEG
	PUBLIC InitUART, TxStrUART, STRLEN

;-----------------------------------------
;--	Main Program			--
;-----------------------------------------
Reset:	MOV   SYCC,#H'07		; HiSpeed Main Clock, Stabi=0
	MOVW  SP,#H'200
	MOVW  A,#H'0030			; IL = 3 !
	MOVW  PS,A			; Init PS register

;-----------------------------------------
main:	PRSTR IniMel
	MOV  IntNum,#H'00		; Clear Test Flag

	CALL InitUART			;

	MOVW A,#TxStr1			; pointer to String
	CALL TxStrUART			; send Strin via UART

WaFin:	MOV  A,nTxStr			; All characters transmitted ?
	BNE  WaFin			; no, then wait

	MOVW A,#TxStr2
	CALL TxStrUART

;-----------------------------------------
Halt:	NOP
	JMP  Halt

Stop:	NOP
	JMP  Stop

;-----------------------------------------
InitUART:
	MOV  A,#0
	MOV  nTxStr,A
        MOV  SMC,#B'01011001		; Initialize UART Control Reg.
	MOV  SRC,#B'00111000		; Dedicated Baud Rate Gen
	MOV  SSD,#B'00101100		; Enable Rx Interrupt
	MOV  ILR3,#H'FC
	SETI
	RET
;-----------------------------------------
TxStrUART:
	MOVW pTxStr,A		; store pointer to TxStr
	CALL STRLEN		; calculate StrLen
	MOV  nTxStr,A		; store length
	SETB SSD:4		; enable Tx Interrupt (TIE)
	RET
;-----------------------------------------
STRLEN:	MOV  R0,#0
	MOVW EP,A
SLenLo:	MOV  A,@EP
	INCW EP
	BEQ  ExStLn
	INC  R0
	BNE  SLenLo
ExStLn:	MOVW A,#0
	MOV  A,R0
	RET
;-----------------------------------------
;--	UART Tx Interrupt Service Rout.	--
;-----------------------------------------
IntUartTx:
	BBC   SSD:5,ErrWr	; if SODR still data, something wrong =>

	PUSHW A			; save registers
	XCHW  A,T
	PUSHW A

	MOV   A,nTxStr		; load Tx count
	BEQ   LastCh
	DECW  A
	MOV   nTxStr,A		; save count -1

	mov   A,#0		; indictate "One Character Send"
	mov   LED1,A

	MOVW  A,pTxStr		; pointer to String
	MOV   A,@A		; load character
	MOV   SODR,A		; into Tx Register
	XCH   A,T		; get LS-Byte of pointer again
	INCW  A			; point to next character
	MOVW  pTxStr,A		; save

	MOV   A,nTxStr		; load Tx count again
	BEQ   LastCh		; if none left =>
ExTxIn:	POPW  A			; restore registers
	XCHW  A,T
	POPW  A
	RETI

LastCh:	CLRB  SSD:4		; Disable Tx Interrupt (TIE)
	mov   A,#0		; indicate "Last Character Send"
	mov   LED2,A
	JMP   ExTxIn		;

ErrWr:	MOV   IntNum,#H'20	; Error Number
	JMP   Stop


;*****************************************
;*****************************************
IrWATCH:MOV  IntNum,#H'1B
	JMP  Stop
IrTIMBA:MOV  IntNum,#H'1A
	JMP  Stop
IrADCON:MOV  IntNum,#H'19
	JMP  Stop
IrUARTT:MOV  IntNum,#H'18
	JMP  IntUartTx
IrUARTR:MOV  IntNum,#H'17
	JMP  Stop
Ir16TIM:MOV  IntNum,#H'16
	JMP  Stop
IrPWC:	MOV  IntNum,#H'15
	JMP  Stop
IrPWM2:	MOV  IntNum,#H'14
	JMP  Stop
IrPWM1:	MOV  IntNum,#H'13
	JMP  Stop
IrSERI:	MOV  IntNum,#H'12
	JMP  Stop
IrEXT2:	MOV  IntNum,#H'11
	JMP  Stop
IrEXT1:	MOV  IntNum,#H'10
	JMP  Stop

;*****************************************
CSEG	ENDS

;-----------------------------------------
;--	Symbol Table Vector		--
;-----------------------------------------
BIOSVAR	DSEG ABS
	ORG 824h
	DW  SymTab			; Pointer To Symbol Table
BIOSVAR	ENDS

;-----------------------------------------
INTVETS	DSEG ABS
	ORG  H'FFE4
	DW   IrWATCH
	DW   IrTIMBA
	DW   IrADCON
	DW   IrUARTT
	DW   IrUARTR
	DW   Ir16TIM
	DW   IrPWC
	DW   IrPWM2
	DW   IrPWM1
	DW   IrSERI
	DW   IrEXT2
	DW   IrEXT1
INTVETS	ENDS

;-----------------------------------------
;--	Reset Vector			--
;-----------------------------------------
RVector CSEG ABS
        ORG 0FFFDh
        DB  1				; external Mode
	DW  Reset
RVector ENDS

	END
