$lo cy xr cp
;/*ͻ*/
;/*                          F U J I T S U				*/
;/*									*/
;/*              M i k r o e l e k t r o n i k   G m b H		*/
;/*									*/
;/*  Filename:       XPOWER.asm					*/
;/*  Description:    "MB89630 External EPROM PowerDown Demonstration"	*/
;/*			(Version for Special TestBoard)			*/
;/*  Series:         MB89630						*/
;/*  Version:        V01.11						*/
;/*  Design:         Edmund Bendels 08.03.96				*/
;/*  Change:								*/
;/*ͼ*/

	NAME   "XPO"			; module name
 &SET SwitchP21 1			; FLG: Switch P21 active only ExtAccess
 &SET SwitchLED 0			; FLG: Use Signalling LED

 &MACRO PLAB ADR
   DB PLABE_\ADR - PLAB_\ADR, 0
PLAB_\ADR   DB "\ADR"
PLABE_\ADR  DW \ADR
 &ENDM
PREINIT	EQU  8				; Number of Interrupts before Act.ExROM

WATCHVCT EQU  0FFE4h			; IRQ B (Watch Timer Interrupt)
PDR2	EQU  04h			; Port2 (P21,P22 IO-port after Reset!)

SYCC	EQU  007h			; System Clock Control
STBC	EQU  008h			; Standby-Control Register
WPCR	EQU  00Bh			; Watch Timer Crontrol Register
BUZR	EQU  011h			;
PDR5	EQU  012h			;

CNTR1	EQU  028h
CNTR2	EQU  029h
CNTR3	EQU  02Ah
COMR1	EQU  02Bh
COMR2	EQU  02Ch

SMC	EQU  02Dh
SRC	EQU  02Eh
SSD	EQU  02Fh
SIDR	EQU  030h
SODR	EQU  030h

EIC2	EQU  025h

ILR1	EQU  07Ch
ILR2	EQU  07Dh
ILR3	EQU  07Eh


INIWPCR	EQU  B'01000110			; Initial for WPCR
WIF	EQU  7				; Bit Number for clearing interrupt

STP	EQU  7
SCS	EQU  2				; Bit Number for Main/Sub Clock Select
TMD	EQU  3				; Bit Number for Watch Mode
P21	EQU  1				; Port Bits
P22	EQU  2				;

LED1	EQU  H'0AE3
LED2	EQU  H'0AE2

CodeRamAdr  EQU H'0400			; Absolute Address of "CodeRAM"
RamVectors  EQU H'0440			; RAM Vectors
StackSize   EQU H'40
;BegRxBuf    EQU H'3000			; Rx Ring Buffer
;EndRxBuf    EQU H'3100
BegRxBuf    EQU H'0280			; Rx Ring Buffer
EndRxBuf    EQU H'0300

;-----------------------------------------
;-----------------------------------------
DIRVAR	DIRSEG
	PUBLIC SecCnt
SecCnt	 RB  1		; Seconds Counter
ExtIntFlg RB 1		; Ext Int2 Happened

			; UART Variables
nTxStr	 RB  1		; number of Bytes to transmitt
pTxStr	 RW  1		; pointer to transmitt string

LastRxCh RB  1		; number of Bytes received
nRxStr	 RB  1		; number of Bytes received
pRxStr	 RW  1		; pointer to receive string

DIRVAR	ENDS

;-----------------------------------------
;-----------------------------------------

DVAR	DSEG
;BegRxBuf RB  50			; Rx Ring Buffer Size
;EndRxBuf:

	 RB  StackSize
StackTop:
DVAR	ENDS

ABSDATA	DSEG ABS
	ORG CodeRamAdr			; Address Definition
	PUBLIC CodeRAM			;
CodeRAM	RB  60				; Reserve Space for Code in IRAM

	ORG RamVectors
IrWATCH:RB  3			;(0) Ext. Int. #1
IrTIMBA:RB  3			;(1) Ext. Int. #2
IrADCON:RB  3			;(2) 8-bit SSI
IrUARTT:RB  3			;(3) 8-bit PWM 1
IrUARTR:RB  3			;(4) 8-bit PWM 2
Ir16TIM:RB  3			;(5) 8-bit PCW
IrPWC:	RB  3			;(6) 16-bit TimerCounter
IrPWM2:	RB  3			;(7) UART Rx
IrPWM1:	RB  3			;(8) UART Tx
IrSERI:	RB  3			;(9) A/D Converter
IrEXT2:	RB  3			;(A) TimeBaseTimer
IrEXT1:	RB  3			;(B) Watch Timer

ABSDATA	ENDS
					; check with LINKER-result !!!

;*****************************************
;--     User Program Reset Entry        --
;*****************************************

Code	CSEG
	PUBLIC AcRamCSize
	DB  "External Power Down Demo V0.2",13,10
	DB  "(C) Fujitus Mikroelektronik 13.3.96",13,10,0

TxStr1	DB 13,10,"UUUUU ExtEPROM LowPower Test Program",13,10,0
TxStr2	DB 13,10,"Last Message : ",0
AcRamCSize: JMP RamCSize	; number of Bytes required for RamCode (JMP=Trick!)

;-----------------------------------------
;--	Some Symbol Info for Monitor	--
;-----------------------------------------
SymTab: DB "SymTab:",0          ; Symbol Table Header
	PLAB Reset
	PLAB IrWATCH
	PLAB IrUARTT
	PLAB DefIntH
	PLAB SMC
	PLAB SRC
	PLAB SSD
	PLAB UartTxISR
	PLAB Main
	PLAB WupAgain
	PLAB RamWatch
	PLAB MainLoop
        DB  00			; End of Symbol Table
        DB  01			; 1 BreakPoint
        DW  MainLoop

;-----------------------------------------
;--	Program Initialization		--
;-----------------------------------------
Reset:	MOV  SYCC,#H'1F			; Main-Clock, Max Speed, Max-WaitTime
	MOV  STBC,#H'30			; Switch to TriState in WatchMode
	MOVW SP,#StackTop		; Initialize Stack Pointer
	MOVW A,#H'0030			; Initialize RegisterBankPointer
	MOVW PS,A			; (Interrupts Disabled)
	MOV  ILR1,#B'11110011		; Enable Ext. Int. 2
	MOV  ILR2,#B'00111111		; Enable UartRx
	MOV  ILR3,#B'01111100		; Enable WatchTimer/UartTx/
	CALL InitRamCode
	CALL InitUART			;

	MOV  SecCnt,#0			; Init Seconds Counter
	MOV  ExtIntFlg,#0		; Init Int Flag
	MOV  WPCR,#INIWPCR		; Enable Watch Interrupt
	MOV  EIC2,#B'00000011		; Enable Ext.Int2, Falling Edge
	SETI				; Enable Interrupts

;-----------------------------------------
;--	Main Program			--
;-----------------------------------------
Main:	CALL BuzSound
	MOVW A,#TxStr1			; pointer to String
	CALL TxStrUART			; send Strin via UART
	CALL WaitEndTx
	CALL DisAbleUART		; Disable UART again

MainLoop:
	MOV  A,ExtIntFlg		; Ext Int. Happened ?
	BEQ  NoUart			; no, then =>
	CALL EnAbleUART			; Enable UART again
	CALL TalkUART
	CALL DisAbleUART		; Disable UART again
	MOV  ExtIntFlg,#0		; clear Flag

NoUart:	CALL RamWatch			; Go into Int.RAM, activate Watch Mode
	CALL BuzTone
	MOV  A,SecCnt
	CMP  A,#30			; Time < 30 Seconds
	BC   MainLoop			; yes, remain in WATCH mode

	CALL BuzTone			; After 30 Second, go to STOP Mode
	CALL RamStop			; Go into Int.RAM, activate Stop Mode
	MOV  SecCnt,#0
	CALL BuzSound
	JMP  MainLoop

	JMP  MainLoop

;-----------------------------------------
;-- Copy some ROM code into RAM area	--
;-----------------------------------------
InitRamCode:
	;-- initialize default "RAM" Vectors --
	MOV  R0,#12			; 12 vectors
	MOVW IX,#RamVectors		; Init RAM Vectors
	MOVW A,#DefIntH			; Address is Default Handler
	MOV  A,#H'21			; OpCode for JMP xxxx
InVLo:	MOV  @IX,A			; store OpCode
	INCW IX
	XCH  A,T			; 16-bit Address
	MOVW @IX,A			; store Address
	INCW IX
	INCW IX
	XCH  A,T			; OpCode again
	DEC  R0
	BNE  InVLo

	;-- initialize coded "RAM" Vectors --
	MOVW A,#WatchISR
	MOVW IrWATCH+1,A
	MOVW A,#UartTxISR
	MOVW IrUARTT+1,A
	MOVW A,#UartRxISR
	MOVW IrUARTR+1,A
	MOVW A,#ExtInt2ISR
	MOVW IrEXT2+1,A

	;-- copy some ROM code into RAM area --
	MOVW IX,#RAMCODE
	MOVW EP,#CodeRAM		;
	MOV  R0,#(RAMEND-RAMCODE)	; number of Bytes
CopLop:	MOV  A,@IX			; load byte
	INCW IX
	MOV  @EP,A			; store byte
	INCW EP
	DEC  R0
	BNE  CopLop			; continue
	RET

;-----------------------------------------
;-----------------------------------------
TalkUART:
	CLRB PDR5:2			; Activate LED
	MOV  A,nRxStr
WaitCR:	MOV  R1,A			; save number of received char
	MOV  BUZR,#1			; Short Buzzer Tone
	MOV  R0,#0
ShWa:	DEC  R0				;
	NOP
	BNE  ShWa
	MOV  BUZR,#0			; Buzzer off again
	MOV  A,LastRxCh			; Carriage RETURN ?
	CMP  A,#13
	BEQ  RxDone

WaNew:	MOV  A,nRxStr			; get number of received char
	CMP  A,R1			; new ?
	BEQ  WaNew			; no, then wait
	JMP  WaitCR			; check CR

RxDone:	MOVW A,#TxStr2			; pointer to String
	CALL TxStrUART			; send String via UART
	CALL WaitEndTx
	MOVW A,#0			; calculate pointer to end of RxStr
	MOV  A,nRxStr
	MOVW A,#BegRxBuf
	CLRC
	ADDCW A
	MOV  A,#0
	XCH  A,T
	MOVW @A,T			; Terminate String

	MOVW A,#BegRxBuf
	CALL TxStrUART			; send String via UART
	CALL WaitEndTx

	CLRI				;
	MOV  A,#0
	MOV  nRxStr,A
	MOV  LastRxCh,A			; Cancel
	MOVW A,#BegRxBuf		; Reset Ring Buffer
	MOVW pRxStr,A			; Address
	SETI
	SETB PDR5:2			; DeActivate LED
	RET

;-----------------------------------------
;--  Generate some Buzzer Sound		--
;-----------------------------------------
BuzSound:
	MOV  R1,#3
BuzLop:	MOV  A,R1
	MOV  BUZR,A
	MOVW A,#0
BuzWait:DECW A
	BNE  BuzWait
	DEC  R1
	BNE  BuzLop
	MOV  BUZR,#0
	RET

BuzTone:MOV  BUZR,#1
	MOVW A,#0
ToWait:	DECW A
	BNE  ToWait
	MOV  BUZR,#0
	RET

;-------------------------
;-------------------------
FatalErr:
DefIntH:
	NOP
	JMP DefIntH

;-------------------------
;--   Watch Timer ISR	--
;-------------------------
WatchISR:
	PUSHW A				; save A and T
	XCHW  A,T
	PUSHW A

	CLRB WPCR:WIF			; Clear Interrupt
	POPW A				; restaure A and T
	XCHW  A,T
	POPW A
	RETI

;-------------------------
;--   Ext.Int 2 ISR	--
;-------------------------
ExtInt2ISR:
	CLRB EIC2:3			; Cancel Pending Flag
	MOV  ExtIntFlg,#1
	RETI

;*****************************************
;**	UART Functions			**
;**	PWM1 as Clock Source		**
;**	(see AppNote on UART)		**
;*****************************************
;--------
InitUART:
;--------
	MOV   A,#0
	MOV   nTxStr,A
	MOV   nRxStr,A
	MOV   LastRxCh,A		; store single Char

	MOVW  A,#BegRxBuf		; Reset Ring Buffer
	MOVW  pRxStr,A			; Address

;	MOV  COMR1,#H'07		; 9600 at 10 MHz
	MOV  COMR1,#H'04		; 9600 at 6,1 MHz
	MOV  CNTR1,#B'00000000		; Fastest Clock
	MOV  CNTR2,#B'10000000		; Start TimerCounter 1

;	MOV  SSD,#B'00101100		; Initialize UART Control Reg (P4x)
	MOV  SSD,#B'00101000		; Initialize UART Control Reg (P3x)
	MOV  SRC,#B'00001000		; Use PWM Timer1 as Clock Souce
        MOV  SMC,#B'01011001		;
	RET
;--------
DisAbleUART:
;--------
	CLRB  SMC:0			; Disable SO-Output
	MOV  SSD,#B'00100100		; Disable Receive Interrupt
	SETB PDR2:P22			; Power Off Max 232
	SETB EIC2:0			; Enable Ext.Int2 again
	RET
;--------
EnAbleUART:
;--------
	CLRB EIC2:0			; DisAble Ext.Int2
	CLRB PDR2:P22			; Power On Max 232
	SETB SMC:0			; Enable SO-Output again
	MOVW A,#H'4000			; additional delay loop, makes sure
EnWaLo:	DECW A				; interruptin character is not received
	BNE  EnWaLo
	MOV  A,SSD			; dummy read Status
	MOV  A,SIDR			; dummy read Character
	MOV  SSD,#B'00101100		; Enable Receive Interrupt
	RET
;--------
WaitEndTx:
;--------
	MOV  A,nTxStr		; length reached 0 ?
	BNE  WaitEndTx		; no, wait =>
	MOVW A,#H'4000		; additional delay loop, since
AdWaLo:	DECW A			; last character may still transmitting
	BNE  AdWaLo
	RET
;--------
TxStrUART:
;--------
	MOVW pTxStr,A		; store pointer to TxStr
	CALL STRLEN		; calculate StrLen
	MOV  nTxStr,A		; store length
	SETB SSD:4		; enable Tx Interrupt (TIE)
	RET
STRLEN:	MOV  R0,#0
	MOVW EP,A
SLenLo:	MOV  A,@EP
	INCW EP
	BEQ  ExStLn
	INC  R0
	BNE  SLenLo
ExStLn:	MOV  A,R0
	RET
;-----------------------------------------
;--	UART Tx Interrupt Service Rout.	--
;-----------------------------------------
UartRxISR:
	PUSHW A			; save registers
	XCHW  A,T
	PUSHW A
	mov   A,SSD
	mov   A,SIDR
	xch   A,T
	AND   A,#H'40		; Framing Error ?
	BNE   ExRxIn		; If Framing Error
	xch   A,T

	MOV   LastRxCh,A	; store single Char
	MOVW  A,pRxStr		; get target address pointer
	MOV   @A,T		; store Char in Buffer
	INCW  A
	MOVW  A,#EndRxBuf	;
	XCHW  A,T
	CMPW  A
	BNE   KepRxP
	MOVW  A,#BegRxBuf	; Reset Ring Buffer
KepRxP:	MOVW  pRxStr,A		; store new Buffer Address
	MOV   A,nRxStr		; increment number of received characters
	INCW  A
	MOV   nRxStr,A
ExRxIn:	POPW  A			; restore registers
	XCHW  A,T
	POPW  A
	RETI

;-----------------------------------------
;--	UART Tx Interrupt Service Rout.	--
;-----------------------------------------
UartTxISR:
	PUSHW A			; save registers
	XCHW  A,T
	PUSHW A
;	mov   A,#0
;	mov   LED1,A
	MOV   A,SSD		; (NOTE: Must be one access to SSD
				; before write to SODR !!!)
	MOV   A,nTxStr		; load Tx count
	BEQ   LastCh
	DECW  A
	MOV   nTxStr,A		; save count -1
	MOVW  A,pTxStr		; pointer to String
	MOV   A,@A		; load character
	MOV   SODR,A		; into Tx Register
	XCH   A,T		; get LS-Byte of pointer again
	INCW  A			; point to next character
	MOVW  pTxStr,A		; save
	MOV   A,nTxStr		; load Tx count again
	BEQ   LastCh		; if none left =>
ExTxIn:	POPW  A			; restore registers
	XCHW  A,T
	POPW  A
	RETI
LastCh:	CLRB  SSD:4		; Disable Tx Interrupt (TIE)
	JMP   ExTxIn		;


;*****************************************
;-----------------------------------------
;--	This code is copied into RAM	--
;-----------------------------------------
;*****************************************
RAMCODE:
X_RamWatch:
	;-----------------------------------------
	;--	Disable Interrupts,		--
	;--	PowerDown ext. EPROM (System)	--
	;--	and activate Sub-WATCH-Mode	--
	;--	(Watch Prescailer will Wake Up)	--
	;-----------------------------------------
	CLRI				; Generally Disable Interrupts
 &IF SwitchP21 NE 0
	SETB PDR2:P21			;** Power Down external EPROM **
 &ENDIF

	CLRB SYCC:SCS			; Switch to Sub-Run Mode
	SETB STBC:TMD			; Activate Watch Mode
	NOP
	;-----------------------------------------
	;--  Watch Prescailer has woken up MC	--
	;-----------------------------------------
;	BBC  WPCR:WIF,x_WakeSyst	; If Wakup not by WPCR-source

X_WupAgain:
	MOV  A,SecCnt			; get Seconds Counter
	INCW A				; increment
	MOV  SecCnt,A			; and store

	CMP  A,#16			; Time > 16 Seconds
	BNC  x_NoL			; yes, => do not flash LED
	CLRB PDR5:2			; Activate LED
	MOVW A,#H'0100
X_Del:	DECW A
	BNE  X_Del
	SETB PDR5:2			; DeActivate LED again

x_NoL:	MOV  A,SecCnt			; get actual time again
	AND  A,#H'07			; Time to Wake Up System every 8 Seconds
	BEQ  x_WakeUpSyst
	;-----------------------------------------------------
	;--  Handle Interrupt without Interrupt Vector Call --
	;--  (Cancel Pending Interrupt, but enable again)   --
	;-----------------------------------------------------
x_RemWa:CLRB WPCR:WIF			; Clear Interrupt Request Source
	JMP  RamWatch			; Go Into PowerDown Mode again

	;-----------------------------------------------------
	;--  PowerUp ext. EPROM (System)		    --
	;--  Handle pending Interrupt with ServiceRoutine   --
	;-----------------------------------------------------
x_WakeUpSyst:
 &IF SwitchP21 NE 0
	CLRB PDR2:P21			;** Power-UP external EPROM **
 &ENDIF
	SETB SYCC:SCS			; Switch to Main-Run Mode
	SETI				; Enable Interrupts
	RET




X_RamStop:
	;-----------------------------------------
	;--	Disable Interrupts,		--
	;--	PowerDown ext. EPROM (System)	--
	;--	and activate Sub-Stop-Mode	--
	;-----------------------------------------
	CLRI				; Generally Disable Interrupts
 &IF SwitchP21 NE 0
	SETB PDR2:P21			;** Power Down external EPROM **
 &ENDIF
	CLRB SYCC:SCS			; Switch to Sub-Run Mode
	SETB STBC:STP			; Activate Watch Mode

	;-----------------------------------------
	;--  External Interrupt has woken up MC	--
	;--  PowerUp ext. EPROM (System) again  --
	;-----------------------------------------

 &IF SwitchP21 NE 0
	CLRB PDR2:P21			;** Power-UP external EPROM **
 &ENDIF
	SETB SYCC:SCS			; Switch to Main-Run Mode
	SETI				; Enable Interrupts
	RET

RAMEND:
;-----------------------------------------
;--	Address Labels in RAM Area	--
;-----------------------------------------
RamWatch EQU X_RamWatch -RAMCODE+CodeRamAdr
RamStop  EQU X_RamStop  -RAMCODE+CodeRamAdr
WupAgain EQU X_WupAgain -RAMCODE+CodeRamAdr
RamCSize EQU RAMEND - RAMCODE		; number of Bytes

;-----------------------------------------

Code	ENDS


;-----------------------------------------
;--	Reset Vector			--
;-----------------------------------------
RVector CSEG ABS
        ORG 0FFFDh
        DB  1				; external Mode
	DW  Reset
RVector ENDS

;--------------------------
;- ROM Interrupt Vectors  -
;--------------------------
INTVETS	DSEG ABS
	ORG  H'FFE4
	DW   IrWATCH
	DW   IrTIMBA
	DW   IrADCON
	DW   IrUARTT
	DW   IrUARTR
	DW   Ir16TIM
	DW   IrPWC
	DW   IrPWM2
	DW   IrPWM1
	DW   IrSERI
;	DW   IrEXT2
	DW   ExtInt2ISR
	DW   IrEXT1
INTVETS	ENDS

;-----------------------------------------
;--	Symbol Table Vector		--
;-----------------------------------------
;BIOSVAR	DSEG ABS
;	ORG 824h
;	DW  SymTab			; Pointer To Symbol Table
;BIOSVAR	ENDS

	end

