$lo cy xr cp
;/*ͻ*/
;/*                          F U J I T S U				*/
;/*									*/
;/*              M i k r o e l e k t r o n i k   G m b H		*/
;/*									*/
;/*									*/
;/*  Filename:       XPOWER.asm					*/
;/*  Description:    "MB89630 External EPROM PowerDown Demonstration"	*/
;/*  Series:         MB89630						*/
;/*  Version:        V01.10						*/
;/*  Design:         Edmund Bendels 09.05.94				*/
;/*  Change:								*/
;/*ͼ*/

;NOTE:	This example demonstrates, how realize a low power-consumption
;	controller-system, even when using the micro-controller in
;	external ROM mode.
;	The example assumes, that the external program ROM (EPROM)
;	can be powered on/off by an output-port signal of the controller.
;	Thus, the controller can power-down the ROM before activating
;	one of its power saving modes (e.g. WATCH-mode)
;	and activate the ROM again when needed.
;	This is realized by some instruction code,
;	copied into the internal RAM during initialization.
;	The transition into the power-saving mode is done within
;	this RAM code.
;	Presuming that global interrupts are disabled via CLRI,
;	program execution will also continue within the RAM area
;	after an interrupt has "waked up" the controller.
;	The controller can then power-on the external ROM,
;	enable global interrupts, process the interrupt and etc.
;	and finally go into the power saving mode again.
;	As a special feature, this examples program also shows
;	how to cancel a pending interrupt request, without executing the
;	interrupt service vector or interrupt service routine (ISR).
;	In this example, the controller is woken up periodically
;	after 1 second by the WATCH-timer.
;	Using a software counter, the ISR (in EPROM) is executed only
;	each 5 second. The other interrupts canceled, so that
;	the external EPROM has to be powered on only after each 5 seconds.

	NAME   "XPOWER"			; module name

 &SET DebugFunctions 0			; Flag: Include Debug Functions
 &INCLUDE "c:\FJ_8L_3\Include\eBIOS.inc"

PREINIT	EQU  4				; Number of Interrupts before Act.ExROM
 
INTVECT EQU  0FFE4h			; IRQ B (Watch Timer Interrupt)
PDR2	EQU  04h			; Port2 (P21,P22 IO-port after Reset!)
SYCC	EQU  007h			; System Clock Control
STBC	EQU  008h			; Standby-Control Register
WPCR	EQU  00Bh			; Watch Timer Crontrol Register
ILR3	EQU  07Eh			; Interrupt Level Register

INIWPCR	EQU  B'01000110			; Initial for WPCR
WIF	EQU  7				; Bit Number for clearing interrupt
SCS	EQU  2				; Bit Number for Main/Sub Clock Select
TMD	EQU  3				; Bit Number for Watch Mode
P21	EQU  1				;

;-----------------------------------------
;-----------------------------------------
DIRVAR	DIRSEG
dummy1	RB  1
DIRVAR	ENDS

;-----------------------------------------
;-----------------------------------------
DVAR	DSEG
	PUBLIC CodeRAM			;
CodeRAM	RB  60				; Reserve Space for Code in IRAM
PreCnt	RB  1				; Pre-Counter before activating ExtRom
DVAR	ENDS
CODERAM	EQU H'0108			; Absolute Address of "CodeRAM"
					; check with LINKER-result !!!

;*****************************************
;--     User Program Reset Entry        --
;*****************************************

Code	CSEG ABS
	ORG H'8000

;-----------------------------------------
;--	Program Initialization		--
;-----------------------------------------
Reset:	MOV  SYCC,#H'1F			; Main-Clock, Max Speed, Max-WaitTime
	MOV  STBC,#H'10			; Keep PinState in WatchMode
;	MOV  STBC,#H'30			; Switch to TriState in WatchMode
	MOVW SP,#H'0180			; Initialize Stack Pointer
	MOVW A,#H'0030
	MOVW PS,A			; Initialize RegisterBankPointer
	MOV  A,#PREINIT			; Init PreCnt Variable
	MOV  PreCnt,A
	CLRI				; Generally Disable Interrupts
	MOV  ILR3,#B'01111111		; Enable Watch Timer Interrupt
	MOV  WPCR,#INIWPCR		; Enable Watch Interrupt

	PRSTR IniMel			; Print String Message

	MOVW IX,#RAMCODE		; Copy some ROM into RAM area
	MOVW EP,#CodeRAM		;
	MOV  R0,#(RAMEND-RAMCODE)	; number of Bytes
CopLop:	MOV  A,@IX			; load byte
	INCW IX
	MOV  @EP,A			; store byte
	INCW EP
	DEC  R0
	BNE  CopLop			; continue


;-----------------------------------------
;--	Main Program			--
;-----------------------------------------
Main:	CALL RamWatch			; Go into Int.RAM, activate Watch Mode
	PRSTR WakeMel			; Print String Message
	JMP  Main

;*****************************************
;-----------------------------------------
;--	This code is copied into RAM	--
;-----------------------------------------
;*****************************************
RAMCODE:
	NOP
X_RamWatch:
	;-----------------------------------------
	;--	Disable Interrupts,		--
	;--	PowerDown ext. EPROM (System)	--
	;--	and activate Sub-WATCH-Mode	--
	;--	(Watch Prescailer will Wake Up)	--
	;-----------------------------------------
	CLRI				; Generally Disable Interrupts
	SETB PDR2:P21			;** Power Down external EPROM **
	CLRB SYCC:SCS			; Switch to Sub-Run Mode
	SETB STBC:TMD			; Activate Watch Mode

	;-----------------------------------------
	;--  Watch Prescailer has woken up MC	--
	;-----------------------------------------
	NOP
X_Wup:	MOV  A,PreCnt			; decrement Pre-Counter variable
	CLRC
;	BNC  x_WakeSyst			; if 0, wake up complete system =>
	SUBC A,#1
	MOV  PreCnt,A
	BEQ  x_WakeSyst			; if 0, wake up complete system =>

	;-----------------------------------------------------
	;--  Handle Interrupt without Interrupt Vector Call --
	;--  (Cancel Pending Interrupt, but enable again)   --
	;-----------------------------------------------------
	MOV  A,LED1			; just Toggle LED1
	XOR  A,#01			; for indication
	MOV  LED1,A

	CLRB WPCR:WIF			; Clear Interrupt Request Source
;	SETI				; Enable Interrupts (just to demonstrate
;					; that No Interrupt pending any more !)

	JMP  RamWatch			; Go Into PowerDown Mode again

	;-----------------------------------------------------
	;--  PowerUp ext. EPROM (System)		    --
	;--  Handle pending Interrupt with ServiceRoutine   --
	;-----------------------------------------------------
x_WakeSyst:
	MOV  A,#PREINIT			; Init PreCnt Variable again
	MOV  PreCnt,A
	CLRB PDR2:P21			;** Power-UP external EPROM **
	NOP
	SETI				; Enable Interrupts
	RET
RAMEND:
;-----------------------------------------
;--	Address Labels in RAM Area	--
;-----------------------------------------
RamWatch EQU X_RamWatch-RAMCODE+CODERAM
;-----------------------------------------

;------------------------
;------------------------
IntRout:PUSHW A				; save A and T
	XCHW  A,T
	PUSHW A
	MOV  A,LED2
	XOR  A,#01
	MOV  LED2,A
	CLRB WPCR:WIF			; Clear Interrupt
	POPW A				; restaure A and T
	XCHW  A,T
	POPW A
	RETI

;-------------------------------------------------
;--	Some Messages send via Monitor BIOS	--
;-------------------------------------------------
IniMel	DB 13,10,"[2J External EPROM-Power Up Test Program",13,10,0
WakeMel	DB 13,10,"Time To Wake Up..",0

;-------------------------------------------------
;--	Symbol Table for Debug Purpose		--
;-------------------------------------------------
SymTab: DB "SymTab:",0          ; Symbol Table Header
	DB LabL1-LabS1,0	; Length of 1st Symbol, dummy byte
LabS1	DB "Reset"		; Symbol Name
LabL1	DW Reset		;
	DB LabL2-LabS2,0
LabS2   DB "Main"
LabL2	DW Main
	DB LabL3-LabS3,0
LabS3   DB "IntRout"
LabL3	DW IntRout
        DB 00                   ; End of Symbol Table
	DB 00			; 1 WatchPoint
Code	ENDS


;-----------------------------------------
;--	Reset Vector			--
;-----------------------------------------
RVector CSEG ABS
        ORG 0FFFDh
        DB  1				; external Mode
	DW  Reset
RVector ENDS

;-----------------------------------------
;--	Symbol Table Vector		--
;-----------------------------------------
BIOSVAR	DSEG ABS
	ORG 824h
	DW  SymTab			; Pointer To Symbol Table
BIOSVAR	ENDS

;--------------------------
;--	Interrupt Vector --
;--------------------------
IVector cseg ABS
        ORG INTVECT
	DW  IntRout
IVector ends

	end

