
************************************************************
*
*       File :  AVERAGE.ASM
*       Description :
*               This code demonstrates an average routine
*                showing the use of the CPU08's DIV inst.
*               8 bit values are read from a table in
*                memory and the average of those numbers
*                is computed.
*       Notes:  Please consult the HC08 Reference Manual
*                for further details on these instructions
*               Code is writtem for educational
*                purposes only
*
************************************************************


TBL_STR EQU     $400            ; starting address of
                                ; table in memory

        ORG     $50
LENGTH  RMB     1               ; length of table
TOT_H   RMB     1               ; high byte of total
TOT_L   RMB     1               ; low byte of total

        ORG     $200

*       The length of this table is predefined as 3 for
*        this example
*       The values in the table start at $401
*       $401 = 50
*       $402 = 60
*       $403 = 70

START   CLR     TOT_H           ; clear TOT_H in mem
        CLR     TOT_L           ; clear TOT_L in mem
        LDX     LENGTH          ; X <- length of table
NEXT    LDA     TBL_STR,X       ; ACCA <-(X+TBL_STR)
        ADD     TOT_L           ; ACCA <- (ACCA)+(TOT_L)
        STA     TOT_L           ; TOT_L <- (ACCA)
        BCS     CS              ; if carry bit is set,
                                ; branch to CS
        BRA     NEXT2           ; branch to next table entry

CS      INC     TOT_H           ; inc the high byte of total

NEXT2   DBNZX   NEXT            ; dec X, if X not 0, then
                                ;   branch to next table entry

        LDHX    TOT_H           ; H <- high byte of dividend
        TXA                     ; ACCA <- low byte of dividend
        LDX     LENGTH          ; X <- load divisor
        DIV                     ; H:ACCA / X
                                ; answer in ACCA with H rem

*       Answer can be found in ACCA, remainder in H
*       Answer is equal to $60 with no remainder

DONE    NOP
        BRA     DONE


*****   Initialize the reset vector
        ORG     $FFFE
        DW      START
