
************************************************************
*
*       File :  BCD.ASM
*       Description :
*               This code demonstrates a BCD routine to
*                be used on the CPU08.
*               Two 16 bit BCD numbers are added together
*                and the result is 16 bit BCD number
*               BCD1 + BCD2 = BCDT
*       Notes:  Please consult the HC08 Reference Manual
*                for further details on these instructions
*               Code is writtem for educational
*                purposes only
*
************************************************************


        ORG     $50
BCD1_H  RMB     1               ; high byte of bcd #1
BCD1_L  RMB     1               ; low byte of bcd #1
BCD2_H  RMB     1               ; high byte of bcd #2
BCD2_L  RMB     1               ; low byte of bcd #2
BCDT_H  RMB     1               ; high byte of bcd total
BCDT_L  RMB     1               ; low byte of bcd total


        ORG     $200

*       Predefine values for the example
*       BCD1 = 150,   BCD1_H = 01 & BCD1_L = 50
*       BCD2 = 250,   BCD2_H = 02 & BCD2_L = 50

*       First, add the low bytes of the 16 bit BCD #s
START   LDA     BCD1_L          ; ACCA <- (bcd #1 low byte)
        ADD     BCD2_L          ; ACCA <- (ACCA)+(bcd #2
                                ;  low byte)
        DAA                     ; decimal adjust accumulator
        STA     BCDT_L          ; store away result to total low

*       Second, add the high bytes of the 16 bit BCD #s
*       Add the carry bit from the previous addition
        LDA     BCD1_H          ; ACCA <- (bcd #1 high byte)
        ADC     BCD2_H          ; ACCA <- (ACCA)+(bcd #2
                                ;  high byte)+C
        DAA                     ; decimal adjust accumulator
        STA     BCDT_H          ; store away result to total high

*       Answer is in BCDT_H and BCDT_L
*       BCDT_H = 04
*       BCDT_L = 00


DONE    NOP
        BRA     DONE


*****   Initialize the reset vector
        ORG     $FFFE
        DW      START
