
************************************************************
*
*       File :  BRANCH.ASM
*       Description :
*               Shows examples for new CPU08 branch
*               instructions - CBEQ, CBEQA, CBEQX
*                              DBNZ, DBNZA, DBNZX
*       Notes:  Comments to the right of some instructions
*                give numbers.
*               CPU05 - 1st # is CPU05 cycle count
*                       2nd # is instruction byte count
*               CPU08 - 1st # is CPU08 cycle count
*                       2nd # is instruction byte count
*               Please consult the HC08 Reference Manual
*                for further details on these instructions
*               Code is written for educational
*                purposes only
*
************************************************************


        ORG     $200

*****   CBEQ - compare and branch if equal, direct
*       ACCA is predefined at $40
*       Memory location $80 contains $40

*       HC05 code               *
LPA     CMP     $80             ;3,2 (ACCA) - ($80)
        BEQ     LP1             ;3,2 if (ACCA) = ($80) then
                                ;    branch to LP1
        BRA     LPA             ;    go to LPA, try again!

*       HC08 code               *
LP1     CBEQ    $80,LPB         ;5,3 if (ACCA)-($80)=0,
                                ;    then branch to LPB
        BRA     LP1             ;    go to LP1

*       Total CPU05 cycles, bytes       = 6,4
*       Total CPU08 cycles, bytes       = 5,3


*****   CBEQA - compare and branch if equal, immediate
*       ACCA is predefined at $50

*       HC05 code               *
LPB     CMP     #$50            ;2,2 (ACCA) - $50
        BEQ     LP2             ;3,2 if (ACCA) = $50, then LP2
        BRA     LPB             ;    go to LPB

*       HC08 code               *
LP2     CBEQA   #$50,LPC        ;4,3 if #$50 = (ACCA), then LPC
        BRA     LP2             ;    go to LP2

*       Total CPU05 cycles, bytes       = 5,4
*       Total CPU08 cycles, bytes       = 4,3


*****   CBEQX - compare and branch if equal, index
*       Index register X is predefined at $60

*       HC05 code               *
LPC     CPX     #$60            ;2,2 X - $60
        BEQ     LP3             ;3,2 if X = $60, then LP3
        BRA     LPC             ;    go to LPC

*       HC08 code               *
LP3     CBEQX   #$60,LPD        ;4,3 if X = $60, then LPD
        BRA     LP3             ;    go to LP3

*       Total CPU05 cycles, bytes       = 5,4
*       Total CPU08 cycles, bytes       = 4,3


*****   DBNZ - decrement and branch if not zero

*       HC05 code               *
*       Memory location $A0 is predefined at $08
LPD     NOP                     ;    used here to represent any
                                ;    number of instructions
        DEC     $A0             ;5,2 decrement ($A0)
        BNE     LPD             ;3,2 if ($A0) not zero, then LPD

*       HC08 code               *
*       Memory location $A0 is predefined at $08
LP4     NOP                     ;    used here to represent any
                                ;    number of instructions
        DBNZ    $A0,LP4         ;5,3 ($A0) = ($A0) - 1
                                ;    if ($A0) not zero, then LP4

*       Total CPU05 cycles, bytes       = 8,4
*       Total CPU08 cycles, bytes       = 5,3


*****   DBNZA - decrement acca and branch if not zero

*       HC05 code               *
*       ACCA is predefined at $06
LPE     NOP                     ;    used here to represent any
                                ;    number of instructions
        DECA                    ;3,1 (ACCA) = (ACCA) - 1
        BNE     LPE             ;3,2 if (ACCA) not zero, then LPE


*       HC08 code               *
*       ACCA is predefined at $06
LP5     NOP                     ;    used here to represent any
                                ;    number of instructions
        DBNZA   LP5             ;3,2 (ACCA) = (ACCA) - 1
                                ;    if (ACCA) not zero, then LP5

*       Total CPU05 cycles, bytes       = 6,3
*       Total CPU08 cycles, bytes       = 3,2


*****   DBNZX - decrement x and branch if not zero

*       HC05 code               *
*       Index register X is predefined at $04
LPF     NOP                     ;    used here to represent any
                                ;    number of instructions
        DECX                    ;3,1 (X) = (X) - 1
        BNE     LPF             ;3,2 if (X) not zero, then LPF

*       HC08 code               *
*       Index register X is predefined at $04
LP6     NOP                     ;    used here to represent any
                                ;    number of instructions
        DBNZX   LP6             ;3,2 (X) = (X) - 1
                                ;    if (X) not zero, then LP6

*       Total CPU05 cycles, bytes       = 6,3
*       Total CPU08 cycles, bytes       = 3,2


DONE    NOP
        BRA     DONE


*****   Initialize the reset vector
        ORG     $FFFE
        DW      LPA
