
************************************************************
*
*       File :  BRANCHX.ASM
*       Description :
*               This code shows an example of using branch
*                algorithms to search for a number in a
*                table. The code will search for $FF in
*                a table. This would signify that in a
*                table of A/D values, an A/D reading
*                was saturated.
*       Notes:  Comments to the right of some instructions
*                give numbers.
*               CPU05 - 1st # is CPU05 cycle count
*                       2nd # is instruction byte count
*               CPU08 - 1st # is CPU08 cycle count
*                       2nd # is instruction byte count
*               Please consult the HC08 Reference Manual
*                for further details on these instructions
*               Code is written for educational
*                purposes only
*
************************************************************


TABLE   EQU     $400            ; starting address of the
                                ;  A/D table


        ORG     $50
TBL_LEN RMB     1               ; memory value containing
                                ; the number of values in
                                ; a the A/D table


        ORG     $200

*****   Search for $FF (saturation) in a table of A/D values
*         TBL_LEN is predefined at $08 for this example
*         Therefore the table is defined from $400 to $407
*       The values given for the total # of cycles and bytes
*         reflect an absolute count with no looping involved
*       An accurate account of the cycle count would involve
*         the table length and whether or not a comparison
*         was made.

*       HC05 code               *
SRCH    LDX     TBL_LEN         ;3,2 X <- (TBL_LEN)
LOOP3   LDA     TABLE-1,X       ;5,3 ACCA <- (TABLE-1+X)
        CMP     #$FF            ;2,2 (ACCA) - $FF
        BEQ     NEXT            ;3,2 if Z=1, then goto NEXT
                                ;    this signifies that a
                                ;    saturation value has been
                                ;    found in the table
        DECX                    ;3,1 X <- X -1
        BNE     LOOP3           ;3,2 if Z=0, then goto LOOP3
                                ;    go look at another value
                                ;    in the table

*       Total # CPU05 cycles    = 19
*       Total # bytes           = 12


*       HC08 code               *
NEXT    LDX     TBL_LEN         ;3,2 X <- (TBL_LEN)
LOOP4   LDA     TABLE-1,X       ;4,3 ACCA <- (TABLE-1+X)
        CBEQA   #$FF,DONE       ;4,3 (ACCA) - $FF
                                ;    if Z=1, then goto DONE
                                ;    this signifies that a
                                ;    saturation value has been
                                ;    found in the table
        DBNZX   LOOP4           ;3,2 X <- X -1
                                ;    if Z=0, then goto LOOP4
                                ;    go look at another value
                                ;    in the table

*       Total # CPU08 cycles    = 14
*       Total # bytes           = 10


DONE    NOP
        BRA     DONE


*****   Initialize the reset vector
        ORG     $FFFE
        DW      SRCH
