
************************************************************
*
*       File :  CUBE.ASM
*       Description :
*               This program takes an 8-bit positive
*                number, X_IN, and cubes it. The answer,
*                Y_IN, is in a 24-bit format.
*               This program also illustrates the
*                value of using the stack for complex
*                subroutines that use parameter passing,
*                local variables, and return values.
*       Stack Description:
*               Given below is a diagram of the stack
*                during the subroutine
*               The numbers on the right specify the
*                number of bytes above the stack pointer
*
*               -------------------------
*               SP ->   ??
*                       VAR1            1
*                       VAR2            2
*                       ACCA            3
*                       H               4
*                       X               5
*                       PC_HIGH         6
*                       PC_LOW          7
*                       Y_HIGH          8
*                       Y_MED           9
*                       Y_LOW          10
*                       X_IN           11
*               -------------------------
*
*       Note :  Please consult the HC08 Reference manual
*                for further HC08 instruction details
*               Code is written for educational
*                purposes only
*
************************************************************


        ORG     $80

X_IN    RMB     1               ;8 bit number to be cubed

        ORG     $200

*****   Load up stack before entering the subroutine
*       Stack is given the 8 bit number to be cubed, X_IN
*       Next, 3 bytes must be made available to the stack
*         for the 24 bit output of the routine
*       3 pushes are made to illustrate this point

START   LDA     X_IN            ;ACCA <- (X_IN)
        PSHA                    ;push parameter X_IN onto stack
        CLRA                    ;zero must be pushed on stack
                                ; allocation for return answer
        PSHA                    ;push Y_Low byte onto stack
        PSHA                    ;push Y_Med byte onto stack
        PSHA                    ;push Y_High byte onto stack

*****   Jump to the Cube subroutine
        JSR     CUBE            ;jump sub to CUBE, Y = X_IN^3

*****   When subroutine is over, reset stack pointer to original
*       location. Pull the answers off the stack when needed.

        AIS     #$04            ;SP <- (SP) + $04

        BRA     DONE            ;branch to the end of this
                                ;example


*****   CUBE subroutine
*****   Given X_IN, find Y = X^3

*       Save X,H, and ACCA on stack
*       Decrement stack for 2 bytes
CUBE    PSHX                    ;push X onto stack
        PSHH                    ;push H onto stack
        PSHA                    ;push ACCA onto stack
        AIS     #-2             ;decrement stack for local var

*       Run the math routine
*       Square X_IN, answer is X:ACCA
        LDA     11T,SP          ;ACCA = X_IN
        LDX     11T,SP          ;X = X_IN
        MUL                     ;X:ACCA = (X)*(ACCA)

*       Store away the high byte answer, X, to var1
        STX     1,SP            ;store high answ to var1

*       Multiply 16 bit result by X_IN
*       Multiply X_IN by low byte of 16 bit square
        LDX     11T,SP          ;X = X_IN
        MUL                     ;X:ACCA = (X)*(ACCA)

*       Store away low byte of 16 bit result
*         to Y_LOW
*       Store high byte of 16 bit result to var2
        STA     10T,SP          ;store low answ to Y_LOW
        STX     2,SP            ;store high answ to var2

*       Multiply high byte of 16 bit result by X_IN
        LDA     11T,SP          ;ACCA <-  X_IN
        LDX     1,SP            ;load X with var1
        MUL                     ;X:ACCA = X_IN * var1

*       Store high byte of answer to Y_HIGH
        STX     8T,SP           ;store high byte to Y_HIGH

*       ADD var2 to the low byte answer to get Y_MED
*       If there is a carry, add one bit to Y_HIGH
        ADD     2T,SP           ;ACCA = var2 + ACCA
        BCS     CS              ;branch if C bit set in CCR
        BRA     FIN             ;C bit is 0, branch to FIN

CS      INC     8T,SP           ;add 1 to Y_HIGH

FIN     STA     9T,SP           ;store ACCA to Y_MED

*       Save X,H, and ACCA on stack
*       Increment stack for 2 bytes
*       Restore X,H, and ACCA
*       Return from the subroutine
        AIS     #$02
        PULA
        PULH
        PULX
        RTS


DONE    NOP
        BRA     DONE


*****   Initialize the reset vector
        ORG     $FFFE
        DW      START
