
************************************************************
*
*       File :  INDEX.ASM
*       Description :
*               Shows examples for new CPU08 indexing
*                instructions - AIX, CLRH, CPHX, LDHX, STHX
*               Not all addressing modes are shown.
*       Note :  Please consult the HC08 Reference Manual
*                for further details on these instructions
*               Code is written for educational
*                purposes only
*
************************************************************


        ORG     $200

*****   AIX - add immediate to index register

START   LDHX    #$1010          ; H:X <- $1010
        AIX     #-10            ; H:X = $1010 + (-$10)
                                ;     = $1000


*****   CLRH - clear index high

        LDHX    #$1290          ; H:X <- $1290
        CLRH                    ; H:X <- $0090


*****   CPHX - compare 16-bit index register

        LDHX    #$1290          ; H:X <- $1290
                                ; CCR = %0110,1000
                                ; CCR before CPHX, Z=0
        CPHX    #$1290          ; H:X <- $1290
                                ; CCR = %0110,1010
                                ; CCR after CPHX, Z=1


*****   LDHX - load 16-bit index register

        LDHX    #$1290          ; H:X <- $1290


*****   STHX - store 16-bit index register

        LDHX    #$1290          ; H:X <- $1290
        STHX    $50             ; ($50) <- (H:X)
                                ; ($50) <- $12
                                ; ($51) <- $90


DONE    NOP
        BRA     DONE


*****   Initialize the reset vector
        ORG     $FFFE
        DW      START
