
************************************************************
*
*       File :  INDEXX.ASM
*       Description :
*               The following code illustarates the
*                different instructions used to address
*                a 512 byte table in memory. HC05 and HC08
*                code is compared.
*       Notes:  Comments to the right of some instructions
*                give numbers.
*               CPU05 - 1st # is CPU05 cycle count
*                       2nd # is instruction byte count
*               CPU08 - 1st # is CPU08 cycle count
*                       2nd # is instruction byte count
*               Please consult the HC08 Reference Manual
*                for further details on these instructions
*               Code is written for educational
*                purposes only
*
************************************************************


*       For the purpose of this example, the table address
*       will be predefined in RAM.
*       TBL_A = $120


TBL_ST0 EQU     $400            ;  start of table, section 0
TBL_ST1 EQU     TBL_ST0+256T    ;  start of table, section 1

        ORG     $50             ;  start of RAM variables
TBL_A   RMB     2               ;  address for table to be
                                ;   accessed by the code


        ORG     $200

*****   Address a 512 byte table with the index register
*****   The table starts at $400 and ends at $5FF

*********************************
*       HC05 code               *
*       CPU05 has to address the table in a section like
*         fashion. Section 0 is between $400 and $4FF.
*         Section 1 is between $500 and $5FF.
*       The 16 bit address is stored in RAM location TBL_A.
*         This is the offset to the table starting
*         at $400, TBL_ST0.
*       Example: Address is $520 = $400 + $120
*                TBL_A   = $01
*                TBL_A+1 = $20

START   LDX     TBL_A+1         ;3,2 X <- (TBL_A+1)
        LDA     TBL_A           ;3,2 ACCA <- (TBL_A)
        BEQ     TBL0            ;3,2 branch to section 0 if 0
        LDA     TBL_ST1,X       ;5,3 ACCA <- (X+TBL_ST1)
        BRA     NEXT            ;3,2 branch when done to
                                ;    the CPU08 example

TBL0    LDA     TBL_ST0,X       ;5,3 ACCA <- (X+TBL_ST0)

*       Total # CPU05 cycles    = 17 (max)
*       Total # bytes           = 11 (max)
*********************************

*********************************
*       HC08 code               *
*       CPU08 has full 16-bit indexed addressing so the
*         table address is loaded from TBL_A in RAM. No
*         memory table sectioning is needed.

NEXT    LDHX    TBL_A           ;4,2 H:X <- (TBL_A)
        LDA     TBL_ST0,X       ;4,3 ACCA <- (X+TBL_ST0)

*       Total # CPU08 cycles    = 8
*       Total # bytes           = 5
*********************************


DONE    NOP
        BRA     DONE


*****   Initialize the reset vector
        ORG     $FFFE
        DW      START
