************************************************************
*
*       File :  MISCINST.ASM
*       Description :
*               Shows examples for 5 misc CPU08 instructions
*               that include BCD, Divide, and CCR operations
*               They are DAA, NSA, DIV, TAP, TPA
*       Notes:  Comments to the right of some instructions
*                give numbers.
*               CPU05 - 1st # is CPU05 cycle count
*                       2nd # is instruction byte count
*               CPU08 - 1st # is CPU08 cycle count
*                       2nd # is instruction byte count
*               Please consult the HC08 Reference manual
*                for further details on these instructions
*               Code is written for educational
*                purposes only
*
************************************************************


        ORG     $200

*****   DAA - decimal adjust accumulator

START   LDA     #$26            ; ACCA <- $26, a BCD #
        ADD     #$37            ; ACCA <- $37 + (ACCA)
                                ; ACCA = $5D, a hex #
        DAA                     ; (ACCA) = 63 = (26 + 37)
                                ; the hex #, 5D, has been
                                ; adjusted to the BCD #, 63


*****   NSA - nibble swap accumulator
*       ACCA is predefined at $37
*       When finished ACCA will be at $73

*       HC05 code               *
        TAX                     ;2,1 X <- (ACCA)
        ROLX                    ;3,1 rotate left X
        ROLA                    ;3,1 rotate left ACCA
        ROLX                    ;3,1 rotate left X
        ROLA                    ;3,1 rotate left ACCA
        ROLX                    ;3,1 rotate left X
        ROLA                    ;3,1 rotate left ACCA
        ROLX                    ;3,1 rotate left X
        ROLA                    ;3,1 rotate left ACCA

*       HC08 code               *
        NSA                     ;3,1 swap the nibbles of ACCA

*       Total CPU05 cycles, bytes       = 26,9
*       Total CPU08 cycles, bytes       = 3,1

*****   DIV - divide 16 bit by 8 bit
*       The immediate addressing mode is used to load the registers
*        to illustrate the components needed to execute
*        a DIV instruction.

        LDHX    #$0200          ; H <- $02
        LDX     #$80            ; X <- $80
        LDA     #$00            ; ACCA <- $00
        DIV                     ; H:A / X = A rem H
                                ; Answer is $04 rem 0


*****   TAP - transfer accumulator to ccr
*       ACCA is predefined at $E2
*       CCR = %0110,0000

        TAP                     ; CCR <- (ACCA)
                                ; CCR = %1110,0010


*****   TPA - transfer ccr to accumulator
*       ACCA is predefined at $00
*       CCR = %1110,0010

        TPA                     ; ACCA <- (CCR)
                                ; ACCA = $E2


DONE    NOP
        BRA     DONE


*****   Initialize the reset vector
        ORG     $FFFE
        DW      START
