
************************************************************
*
*       File :  MOVE.ASM
*       Description :
*               Shows examples for the MOV instruction
*               All four addressing modes are illustrated
*               05 and 08 code is compared
*       Notes:  Comments to the right of some instructions
*                give numbers.
*               CPU05 - 1st # is CPU05 cycle count
*                       2nd # is instruction byte count
*               CPU08 - 1st # is CPU08 cycle count
*                       2nd # is instruction byte count
*               Please consult the HC08 Reference Manual
*                for further details on these instructions
*               Code is written for educational
*                purposes only
*
************************************************************


        ORG     $200

*****   Move Immediate value to Direct memory location

*       HC05                    *
START   LDA     #$30            ;2,2 ACCA <- $30
        STA     $80             ;4,2 ($80) <- (ACCA)

*       HC08                    *
        MOV     #$30,$80        ;4,3 ($80) <- $30

*       Total CPU05 cycles, bytes       = 6,4
*       Total CPU08 cycles, bytes       = 4,3

*****   Move Direct mem value to Direct mem location

*       HC05                    *
        LDA     $80             ;3,2 ACCA <- ($80)
        STA     $90             ;4,2 ($90) <- (ACCA)

*       HC08                    *
        MOV     $80,$90         ;5,3 ($90) <- ($80)

*       Total CPU05 cycles, bytes       = 7,4
*       Total CPU08 cycles, bytes       = 5,3

*****   Move contents of Indexed to Direct mem location, post inc Xreg

*       HC05                    *
        LDX     #$80            ;    X <- $80
        LDA     ,X              ;3,1 ACCA <- (X)
        STA     $90             ;4,2 ($90) <- (ACCA)
        INCX                    ;3,1 X <- X + 1

*       HC08                    *
        LDX     #$80            ;    X <- $80
        MOV     X+,$90          ;4,2 ($90) <- (X)
                                ;    X <- X + 1

*       Total CPU05 cycles, bytes       = 10,4
*       Total CPU08 cycles, bytes       =  4,2

*****   Move Direct mem contents to Indexed location, post inc Xreg

*       HC05                    *
        LDX     #$90            ;    X <- $90
        LDA     $80             ;3,2 ACCA <- ($80)
        STA     ,X              ;4,1 (X) <- (ACCA)
        INCX                    ;3,1 X <- X + 1

*       HC08                    *
        LDX     #$90            ;    X <- $90
        MOV     $80,X+          ;4,2 (X) <- ($80)
                                ;    X <- X + 1

*       Total CPU05 cycles, bytes       = 10,4
*       Total CPU08 cycles, bytes       =  4,2


*****   Initialize the reset vector
        ORG     $FFFE
        DW      START
