
************************************************************
*
*       File :  MOVEX.ASM
*       Description :
*               A user wants to start an application one of
*                two different ways. The user sets the
*                application on the MCU by the logic level
*                of Port D, bit 3. Once out of reset, the
*                MCU reads Port D and moves data from ROM
*                into the RAM configuration registers
*                according to the logic level of bit 3.
*       Notes:  Comments to the right of some instructions
*                give numbers.
*               CPU05 - 1st # is CPU05 cycle count
*                       2nd # is instruction byte count
*               CPU08 - 1st # is CPU08 cycle count
*                       2nd # is instruction byte count
*               Please consult the HC08 Reference Manual
*                for further details on these instructions
*               Code is written for educational
*                purposes only
*
************************************************************


*       For the purpose of this example, we will be using
*       random ctrl registers for the code. They are listed
*       below in an equate table


TBL     EQU     $1000           ; start of table
PORTD   EQU     $03             ; port D data register
PORTADR EQU     $04             ; port A data direction register
PORTBDR EQU     $05             ; port B data direction register
SPICTRL EQU     $0A             ; SPI control register
SCICTRL EQU     $0E             ; SCI control register
TIMCTRL EQU     $12             ; Timer control register


        ORG     $200

*****   If bit 3 = 0 when read, then the table
*       starts at $1000
*       If bit 3 = 1 when read, then the table
*       starts at $1008

*********************************
*       HC05 code               *

START05 LDA     PORTD           ;3,2 ACCA <- (PORTD)
        AND     #$08            ;2,2 clear ACCA except bit 3
                                ;    ACCA = 0 or 8
        TAX                     ;2,1 X <- (ACCA)
                                ;    set the offset of X

        LDA     TBL,X           ;5,3 ACCA <- (TBL+X)
        STA     PORTADR         ;4,2 (PORTADR) <- (ACCA)
        INCX                    ;3,1 X <- X + 1
        LDA     TBL,X           ;5,3 ACCA <- (TBL+X)
        STA     PORTBDR         ;4,2 (PORTBDR) <- (ACCA)
        INCX                    ;3,1 X <- X + 1
        LDA     TBL,X           ;5,3 ACCA <- (TBL+X)
        STA     SPICTRL         ;4,2 (SPICTRL) <- (ACCA)
        INCX                    ;3,1 X <- X + 1
        LDA     TBL,X           ;5,3 ACCA <- (TBL+X)
        STA     SCICTRL         ;4,2 (SCICTRL) <- (ACCA)
        INCX                    ;3,1 X <- X + 1
        LDA     TBL,X           ;5,3 ACCA <- (TBL+X)
        STA     TIMCTRL         ;4,2 (TIMCTRL) <- (ACCA)

*       Total # CPU05 cycles    = 64
*       Total # bytes           = 34
*********************************

*********************************
*       HC08 code               *

START08 LDHX    #TBL            ;3,3 H:X <- TBL
        LDA     PORTD           ;3,2 ACCA <- (PORTD)
        AND     #$08            ;2,2 clear ACCA except bit 3
                                ;    ACCA = 0 or 8
        TAX                     ;1,1 X <- (ACCA)
                                ;    set the offset of X

        MOV     X+,PORTADR      ;4,2 (PORTADR) <- (H:X)
                                ;    X <- X + 1
        MOV     X+,PORTBDR      ;4,2 (PORTBDR) <- (H:X)
                                ;    X <- X + 1
        MOV     X+,SPICTRL      ;4,2 (SPICTRL) <- (H:X)
                                ;    X <- X + 1
        MOV     X+,SCICTRL      ;4,2 (SCICTRL) <- (H:X)
                                ;    X <- X + 1
        MOV     X+,TIMCTRL      ;4,2 (TIMCTRL) <- (H:X)
                                ;    X <- X + 1

*       Total # CPU08 cycles    = 29
*       Total # bytes           = 18
*********************************


DONE    NOP
        BRA     DONE


*****   Initialize the reset vector
        ORG     $FFFE
        DW      START05
