
************************************************************
*
*       File :  SIGNBRA.ASM
*       Description :
*               Shows examples for new CPU08 signed branch
*                instructions - BGE, BGT, BLE, BLT
*               The examples demonstrate two's complement
*                math with branching.
*       Note :  Please consult the HC08 Reference Manual
*                for further details on these instructions
*               Code is written for educational
*                purposes only
*
************************************************************


        ORG     $200


*****   BGE - branch if greater than or equal
*       ACCA is predefined at $FF

LP_BGE  CMP     #$FF            ; (ACCA) - $FF, [ -1 - (-1) ]
        BGE     LP_BGT          ; if ACCA >= $FF, then
                                ; branch to LP_BGT
        BRA     LP_BGE          ; go to LP_BGE


*****   BGT - branch if greater than
*       ACCA is predefined at $07

LP_BGT  CMP     #$FF            ; (ACCA) - $FF, [ 7 - (-1) ]
        BGT     LP_BLE          ; if ACCA > $FF, then
                                ; branch to LP_BLE
        BRA     LP_BGT          ; go to LP_BGT


*****   BLE - branch if less than or equal
*       ACCA is predefined at $FF

LP_BLE  CMP     #$FF            ; (ACCA) - $FF, [ -1 - (-1) ]
        BLE     LP_BLT          ; if ACCA <= $FF, then
                                ; branch to LP_BLT
        BRA     LP_BLE          ; go to LP_BLE


*****   BLT - branch if less than
*       ACCA is predefined at $FF

LP_BLT  CMP     #$07            ; $FF - $07, [ -1 - (7) ]
        BLT     DONE            ; if ACCA < $FF, then
                                ; branch to DONE
        BRA     LP_BLT          ; go to LP_BLT


DONE    NOP
        BRA     DONE


*****   Initialize the reset vector
        ORG     $FFFE
        DW      LP_BGE
