************************************************************
*
*       File :  SP.ASM
*       Description :
*               Shows examples for new CPU08 stack pointer
*                instructions - AIS, PSHA, PSHH, PSHX
*                               PULA, PULH, PULX, TSX, TXS
*               Not all addressing modes are shown.
*       Note :  Please consult the HC08 Reference Manual
*                for further details on these instructions
*               Code is written for educational
*                purposes only
*
************************************************************


        ORG     $200

*****   AIS - add immediate to stack pointer
*       SP is predefined at $0FE0

START   AIS     #$1F            ; SP <- $0FE0 + $1F
                                ; SP = $0FFF


*****   PSHA - push accumulator onto stack
*       SP is predefined at $0FFF
*       ACCA = $80

        PSHA                    ; ($0FFF) <- $80
                                ; SP <-  SP-$01
                                ; SP = $0FFE


*****   PSHH - push index register H onto stack
*       SP is predefined at $0FFE
*       H:X = $2050

        PSHH                    ; ($0FFE) <- $20
                                ; SP <-  SP-$01
                                ; SP = $0FFD

*****   PSHX - push index register X onto stack
*       SP is predefined at $0FFD
*       H:X = $2050

        PSHX                    ; ($0FFD) = $50
                                ; SP <-  SP-$01
                                ; SP = $0FFC


*****   PULX - pull index register X from stack
*       SP is predefined at $0FFC
*       $0FFD = $50
*       H:X = $0000

        PULX                    ; SP <-  SP+$01
                                ; SP = $0FFD
                                ; X <- ($0FFD)
                                ; H:X = $0050


*****   PULH - pull index register H from stack
*       SP is predefined at $0FFD
*       $0FFE = $20
*       H:X = $0050

        PULH                    ; SP <-  SP+$01
                                ; SP = $0FFE
                                ; H <- ($0FFE)
                                ; H:X = $2050


*****   PULA - pull accumulator from stack
*       SP is predefined at $0FFE
*       $0FFF = $80
*       ACCA = $00

        PULA                    ; SP <-  SP+$01
                                ; SP = $0FFF
                                ; ACCA <- ($0FFF)
                                ; ACCA = $80


*****   TSX - transfer stack pointer to index register
*       SP is predefined at $0FF5
*       H:X = $1290

        TSX                     ; H:X <- SP+$01
                                ; H:X = $0FF6


*****   TXS - transfer index register to stack pointer
*       SP is predefined at $0FF5
*       H:X = $1290

        TXS                     ; SP <- H:X-$01
                                ; SP = $128F


DONE    NOP
        BRA     DONE


*****   Initialize the reset vector
        ORG     $FFFE
        DW      START
