`timescale 1ns/1ns
module databus (DH, DL, DP, MEMD, MEMDP, CLK, N_RESET, R_nW, BURST,
                FLASH_DB, FLASH_DBP, BUS_REQ, BUSREQ_FLASH, FLASH_TA, 
                SRAM_TA, DONE, DONE_FLASH, N_MEMOE, N_TA ) ;

 inout [0:31] DH, DL;
 inout [0: 7] DP, MEMDP;
 inout [0:63] MEMD ;

 input BUS_REQ, BUSREQ_FLASH, CLK, N_RESET, R_nW, BURST, N_MEMOE;
 input [0:63] FLASH_DB ;
 input [0: 7] FLASH_DBP ;
 input FLASH_TA, SRAM_TA, DONE, DONE_FLASH;  // Flash & SRAM transfer completed.
 
 output N_TA;           // data transfer acknowledge.

 // Module declarations:
 
 reg [0:31] DH_O, DL_O ;
 reg [0: 7] DP_O, MEMDP_O ;
 reg [0:63] MEMD_O ;
 reg [0:31] OUT_DH, OUT_DL ;
 reg [0: 7] OUT_DP, OUT_MEMDP ;
 reg [0:63] OUT_MEMD ;
 reg N_TAO, DATA_OE, DATA_OEW;
 
//*********************************************************************
// Tristate outputs controlled by DATA_OE and DATA_OEW signasl for 
// the current bus tenure. PowerPC 60X data bus I/O and memory I/O
// Enable tristate I/O one clock before data valid to provide enough
// time for the buffer to turn on. 
//*********************************************************************
 
 always @ (DATA_OE or OUT_DH or OUT_DL or OUT_DP)
   begin
     // If read cycle route MEMD and MEMDP to DH, DL, and DP outputs. 
     DH_O    = ( DATA_OE ) ? OUT_DH    :32'hZZZZ_ZZZZ ;
     DL_O    = ( DATA_OE ) ? OUT_DL    :32'hZZZZ_ZZZZ ;
     DP_O    = ( DATA_OE ) ? OUT_DP    : 8'hZZ ;
   end

 always @ (DATA_OEW or OUT_MEMD or OUT_MEMDP)   
   begin
     // SRAM and FLASH memory data bus I/O
     // If write cycle output DH, DL, DP on MEMD and MEMDP outputs.
     MEMD_O  = ( DATA_OEW ) ? OUT_MEMD  :64'hZZZZ_ZZZZ_ZZZZ_ZZZZ ;
     MEMDP_O = ( DATA_OEW ) ? OUT_MEMDP : 8'hZZ ;
   end
 // Add output delay to emulate switching characteristics of FPGA.
 assign #3 DH = DH_O;
 assign #3 DL = DL_O;
 assign #3 DP = DP_O;
 assign #3 MEMD  = MEMD_O;
 assign #3 MEMDP = MEMDP_O;
 assign #3 N_TA  = N_TAO;

 always @ (posedge CLK or negedge N_RESET )
   begin
   if ( ~N_RESET )
     begin
       OUT_DH    <= 32'h0000_0000 ;
       OUT_DL    <= 32'h0000_0000 ;
       OUT_DP    <=  8'h00 ;
       OUT_MEMD  <= 64'h0000_0000_0000_0000 ;
       OUT_MEMDP <=  8'h00 ; 
       DATA_OE   <= 1'b0;  // tristate 60x bus output driver.     
       DATA_OEW  <= 1'b0;  // tristate memory output driver.
       N_TAO     <= 1'b1;
     end
   else
     begin 
       // multiplexer for SRAM or FLASH data presentation to uP.
       
       OUT_DH    <=  ( BUS_REQ ) ? MEMD[ 0:31] : FLASH_DB[0 :31] ;  
       OUT_DL    <=  ( BUS_REQ ) ? MEMD[32:63] : FLASH_DB[32:63] ; 
       OUT_DP    <=  ( BUS_REQ ) ? MEMDP       : FLASH_DBP ;
       OUT_MEMD  <= {DH, DL} ;
       OUT_MEMDP <=  DP ;
       DATA_OE   <=  R_nW & ( ( DONE_FLASH | FLASH_TA ) |  ( ~N_MEMOE ) ); 
       DATA_OEW  <= ~R_nW & ( (BUSREQ_FLASH & ( ~N_TAO | FLASH_TA )) | (BUS_REQ & ~DONE ) );

       // delay N_TA to line up with data valid on bus.
       N_TAO     <= ( R_nW )  ? ~( FLASH_TA | SRAM_TA ) : 
                    ( BURST ) ? ~( BUS_REQ & ~( SRAM_TA |DONE ) ) : ~( BUS_REQ & ~DONE ) ; 
     end
   end   
endmodule 



