`timescale 1ns/1ns
module top_60x (N_RESET, SYS_CLK, A, N_TS, TT, N_TBST, TSIZ, N_AACK,  N_ARTRY, 
		N_BRA, N_BRB, N_BGA, N_BGB, N_DBGA, N_DBGB, 
		DH, DL, DP, N_TA, N_DRTRY, N_TEA, 
		MEMA, MEMD, MEMDP, N_MEMBEW, N_MEMCE, 
		N_MEMOE, N_MEMADV, N_MEMADSC, BANKSEL, 
	        N_FLASHCE, N_FLASHOE, N_FLASHWE, FLASH_ADR ) ;

input N_RESET ;
input SYS_CLK ;         // System clock input.

input  N_BRA ;          // uP_A address bus request.
input  N_BRB ;	        // uP_B address bus request. 
output N_BGA ;	        // Address bus grant for uP_A.
output N_BGB ;	        // Address bus grant for uP_B. 

input N_TS ;	        // Transfer start asserted by bus master.
input [0:4] TT;         // Transfer type bits.
input [0:2] TSIZ;       // Transfer size.
input  N_TBST;          // Transfer burst.
input [0:31] A ; 	// Processor address bus.
output N_AACK ;		// Address acknowledge to address bus master.
input N_ARTRY ;         // Address retry asserted by address bus snooper.

output N_DBGA ;		// Data bus grant for uP_A.
output N_DBGB ;         // Data bus grant for uP_B.

inout [0:31] DH ;  	// Most significant uP data bus word.
inout [0:31] DL ;  	// Least significant uP data bus word.
inout [0:7]  DP ;   	// Odd data parity.

output N_TA;            // Data transfer acknowledge. Each data beat.
output N_DRTRY;         // Retry data transfer.
output N_TEA;           // Data transfer error acknowledge. Assert with N_TA.
inout [0:63] MEMD ;	// SSRAM data bus to/from external memory.
inout [0:7] MEMDP ;	// SSRAM data parity to/from external memory.

output [0:17]  MEMA ;	// SSRAM memory address.
output [0: 7] N_MEMBEW;	// SSRAM byte write enables.
output N_MEMCE ;        // SSRAM chip enable.
output N_MEMOE ;        // SSRAM output enable.   
output N_MEMADV ;	// SSRAM advance internal address counter.
output N_MEMADSC ;  	// SSRAM store external address.
output [0:1] BANKSEL;  // SRAM bank selection (address bits A[9:10]).

output N_FLASHCE;  	// Flash memory chip enable.
output N_FLASHOE;	// Flash memory output enable.
output N_FLASHWE;  	// Flash memory write enable.
output [0:1] FLASH_ADR; // Flash address bits (0:1).

// This is the top level verilog module for the PPC60X refence design.
// It assumes an external flash memory and external SRAM memory.
// The bus structures are all big endian format.

// Module declarations:
  wire BURST, R_nW, BUS_REQ, BUSREQ_FLASH, DONE, DONE_FLASH, FLASH_TA ;
  wire ENABLE_XFR , DATAXFR;
  wire [0:1] FLASH_ADR;
  wire [0:7]  BWE;
  wire [0:63] FLASH_DB ;
  wire [0:7]  FLASH_DBP ;

  wire [0:63] MEMD;
  wire [0:31] DH, DL;
  wire [0: 7] DP, MEMDP;
  
// Instantiate address bus arbiter module:
adr_arb my_arbb (.CLK 		( CLK ),
                 .N_RESET	( N_RESET ), 
                 .N_TS 		( N_TS ), 
                 .N_BRA		( N_BRA ),
                 .N_BRB  	( N_BRB ), 
                 .ADR_BRA	( ADR_BRA ), 
                 .ADR_BRB 	( ADR_BRB ), 
                 .N_BGA         ( N_BGA ), 	
                 .N_BGB         ( N_BGB )
                );

//Instantiate global buffers on Sys_clock (and Reset?) Input Ports. 
//BUFG     U1      (.I(SYS_CLK), .O(CLK));
  assign CLK = SYS_CLK;


databus my_dbus (.DH( DH ), .DL( DL ), .DP( DP ),
                 .MEMD( MEMD ), .MEMDP( MEMDP ), 
                 .FLASH_DB ( FLASH_DB ), .FLASH_DBP( FLASH_DBP ),
                 .CLK( CLK ), .N_RESET( N_RESET ), .BURST( BURST ),
                 .R_nW( R_nW ), .BUS_REQ ( BUS_REQ ), 
                 .BUSREQ_FLASH( BUSREQ_FLASH), .FLASH_TA (FLASH_TA ), 
                 .SRAM_TA( SRAM_TA ), .DONE( DONE ), .DONE_FLASH( DONE_FLASH ),
                 .N_MEMOE( N_MEMOE ), .N_TA( N_TA ) 
                );

// Instatiate address pipeline and address decoder logic.
adrpipe my_pipe (.A		( A ), 
		 .N_TS		( N_TS ), 
		 .TT		( TT ), 
		 .TSIZ		( TSIZ ), 
		 .N_TBST	( N_TBST ), 
                 .MEMA		( MEMA ),                   
                 .BURST		( BURST),  
                 .CLK		( CLK ), 
                 .R_nW          ( R_nW ),
                 .BWE           ( BWE[0:7] ), 
                 .N_RESET	( N_RESET ),
                 .ENABLE_XFR    ( ENABLE_XFR ),
                 .DATAXFR       ( DATAXFR ),
                 .BUS_REQ       ( BUS_REQ ),
                 .BUSREQ_FLASH  ( BUSREQ_FLASH),
                 .BANKSEL       ( BANKSEL ),
                 .DONE          ( DONE ),
                 .DONE_FLASH    ( DONE_FLASH )
                );


// Instantiate data bus arbiter.
dataflow my_data (.N_TS		( N_TS ),
                  .N_AACK	( N_AACK ), 
                  .N_ARTRY	( N_ARTRY ), 
                  .ADR_BRA	( ADR_BRA ), 
                  .ADR_BRB	( ADR_BRB ), 
                  .N_DBGA	( N_DBGA ), 
                  .N_DBGB	( N_DBGB ), 
                  .DATAXFR      ( DATAXFR ),
                  .ENABLE_XFR   ( ENABLE_XFR ), 
                  .CLK		( CLK ), 
                  .N_RESET	( N_RESET ), 
                  .N_DBB		( N_DBB ),
                  .BUS_REQ      ( BUS_REQ ),
                  .BUSREQ_FLASH ( BUSREQ_FLASH ),
                  .DONE         ( DONE )
                 );


// Instantiate flash memory controller module:
// AMD29400 flash organized as 256Kx16-bit.
flash_if my_boot (.CLK		  ( CLK ), 
		  .N_RESET	  ( N_RESET ),
		  .R_nW	  	  ( R_nW ), 
		  .BUSREQ_FLASH   ( BUSREQ_FLASH ),
		  .DONE_FLASH     ( DONE_FLASH ), 
		  .N_FLASHCE 	  ( N_FLASHCE ), 
		  .N_FLASHWE	  ( N_FLASHWE ), 
		  .N_FLASHOE	  ( N_FLASHOE ),
		  .FLASH_ADR      ( FLASH_ADR[0:1] ),
		  .MEMD           ( MEMD[0:15] ),
		  .FLASH_DB       ( FLASH_DB ),
		  .FLASH_DBP      ( FLASH_DBP ),
		  .FLASH_TA       ( FLASH_TA )
		 );

// Instantiate the SSRAM memory controller module:
// Only one bank of memory currently supported for reference design.
// Note: Tristate buffers not currently implemented.
sramctl my_sram (.N_RESET  ( N_RESET ), 
		 .RnW      ( R_nW ), 
		 .BUSREQ   ( BUS_REQ ), 
		 .BURST    ( BURST ), 
		 .BWE      ( BWE[0:7] ), 
		 .CLK      ( CLK ), 
		 .N_CE     ( N_MEMCE ), 
		 .N_OE     ( N_MEMOE ), 
		 .N_WE     ( N_MEMBEW ),
		 .N_ADV    ( N_MEMADV ), 
		 .N_ADSC   ( N_MEMADSC ), 
		 .DONE     ( DONE ),
		 .SRAM_TA  ( SRAM_TA )
		);



endmodule 

