	Page	58,132
	Title	MESSAGE.ASM	Apple Emulator (65C02 Processor)
;******************************************************************************
;
;   Name:	MESSAGE.ASM	Apple Emulator (65C02 Processor)
;
;   Group:	Emulator
;
;   Revision:	1.00
;
;   Date:	January 30, 1988
;
;   Author:	Randy W. Spurlock
;
;******************************************************************************
;
;  Module Functional Description:
;
;		This module contains all of the messages for the Apple
;	emulator. (All messages are in the code segment)
;
;******************************************************************************
;
;  Changes:
;
;    DATE     REVISION				DESCRIPTION
;  --------   --------	-------------------------------------------------------
;   1/30/88	1.00	Original
;
;******************************************************************************
	Page
;
;  Public Declarations
;
	Public	Invalid_Command 	; Invalid command format string
	Public	Exe_Usage		; Execute command usage format string
	Public	Go_Usage		; Go command usage format string
	Public	Print_Usage		; Print command usage format string
	Public	Eval_Usage		; Eval command usage format string
	Public	Eval_Arg		; Evaluation argument list
	Public	Eval_Fmt		; Evaluation format string
	Public	Dump_Usage		; Dump command usage format string
	Public	Dbyte_Usage		; Dump byte command usage format string
	Public	Dword_Usage		; Dump word command usage format string
	Public	Code_Usage		; Code command usage format string
	Public	Reg_Usage		; Register command usage format string
	Public	Radix_Usage		; Radix command usage format string
	Public	Radix_Arg		; Radix dump argument list
	Public	Radix_Fmt		; Radix dump format string
	Public	Help_Usage		; Help command usage format string
	Public	Trace_Usage		; Trace command usage format string
	Public	Enter_Usage		; Enter command usage format string
	Public	Ebyte_Usage		; Enter byte command usage format string
	Public	Eword_Usage		; Enter word command usage format string
	Public	Fill_Usage		; Fill command usage format string
	Public	Move_Usage		; Move command usage format string
	Public	Compare_Usage		; Compare command usage format string
	Public	Search_Usage		; Search command usage format string
	Public	Bpoint_Usage		; Set breakpoint command usage format
	Public	Bdsable_Usage		; Disable breakpoint usage format string
	Public	Benable_Usage		; Enable breakpoint usage format string
	Public	Bclear_Usage		; Clear breakpoint usage format string
	Public	Blist_Usage		; List breakpoint usage format string
	Public	Proceed_Usage		; Process command usage format string
	Public	Flip_Usage		; Flip command usage format string
	Public	Continue_Fmt		; Continue message format string
	Public	Diff_Arg		; Difference message argument list
	Public	Diff_Fmt		; Difference message format string
	Public	Find_Arg		; Find message argument list
	Public	Find_Fmt		; Find message format string
	Public	Break_Arg		; Breakpoint argument list
	Public	Break_Fmt		; Breakpoint format string
	Public	Break_Status		; Pointer to status string
	Public	Break_Type		; Pointer to type string
	Public	Enable_String		; Breakpoint enabled string
	Public	Disable_String		; Breakpoint disabled string
	Public	Software_String 	; Software type string
	Public	Illegal_String		; Illegal type string
	Public	Read_String		; Hardware read type string
	Public	Write_String		; Hardware write type string
	Public	Access_String		; Hardware access type string
	Public	Execute_String		; Execution type string
	Public	Help_Table		; Debug command help message table
	Public	Usage_Table		; Debug command usage message table
;
;  External Declarations
;
	Extrn	Radix:Word		; Current numeric radix value	 (DATA)
	Extrn	Value:Word		; Current value storage area	(DEBUG)
	Extrn	Compare:Word		; Comparison value storage area (DEBUG)
	Extrn	Current_Address:Word	; Current address value 	(DEBUG)
	Extrn	Compare_Address:Word	; Compare address value 	(DEBUG)
	Extrn	Break_Address:Word	; Breakpoint address value	(DEBUG)
	.286c				; Include 80286 instructions
	Page
;
;  Define the emulator code segment
;
Emulate Segment Word Public 'EMULATE'   ; Emulator code segment
	Assume	cs:Emulate, ds:Nothing, es:Nothing
;******************************************************************************
;
;	Define all the needed messages
;
;******************************************************************************
Invalid_Command Equ	This Byte	; Invalid command format string
		Db	"\nInvalid command - type help",0
Exe_Usage	Equ	This Byte	; Execute command usage format string
		Db	"\nX",0
Go_Usage	Equ	This Byte	; Go command usage format string
		Db	"\nGo <=address> <breakpoint>",0
Print_Usage	Equ	This Byte	; Print command usage format string
		Db	"\n? expression",0
Eval_Usage	Equ	This Byte	; Eval command usage format string
		Db	"\nEvaluate expression[s]",0
Eval_Arg	Equ	This Word	; Evaluation argument list
		Dw	Offset Value	; For binary print value
		Dw	Offset Value	; For octal print value
		Dw	Offset Value	; For decimal print value
		Dw	Offset Value	; For hexadecimal print value
Eval_Fmt	Equ	This Byte	; Evaluation format string
		Db	"\n%016bz %6oo %6dt %04Xh",0
Dump_Usage	Equ	This Byte	; Dump command usage format string
		Db	"\nDump <address>",0
Dbyte_Usage	Equ	This Byte	; Dump byte command usage format string
		Db	"\nDByte <address>",0
Dword_Usage	Equ	This Byte	; Dump word command usage format string
		Db	"\nDWord <address>",0
Code_Usage	Equ	This Byte	; Unassemble command usage format string
		Db	"\nUnassemble <address>",0
Reg_Usage	Equ	This Byte	; Register command usage format string
		Db	"\nRegister register value"
		Db	"\n     Where register is PC, A, X, or Y",0
Radix_Usage	Equ	This Byte	; Radix command usage format string
		Db	"\nRAdix <value>"
		Db	"\n     Where value is 2, 8, 10, or 16",0
Radix_Arg	Equ	This Word	; Radix dump argument list
		Dw	Offset Radix	; Current radix value
Radix_Fmt	Equ	This Byte	; Radix dump format string
		Db	"\nCurrent radix is%3ut",0
Help_Usage	Equ	This Byte	; Help command usage format string
		Db	"\nHelp <command>",0
Trace_Usage	Equ	This Byte	; Trace command usage format string
		Db	"\nTrace <=address> <count>",0
Enter_Usage	Equ	This Byte	; Enter command usage format string
		Db	"\nEnter address value[s]",0
Ebyte_Usage	Equ	This Byte	; Enter byte command usage format string
		Db	"\nEByte address value[s]",0
Eword_Usage	Equ	This Byte	; Enter word command usage format string
		Db	"\nEWord address value[s]",0
Fill_Usage	Equ	This Byte	; Fill command usage format string
		Db	"\nFill range value[s]",0
Move_Usage	Equ	This Byte	; Move command usage format string
		Db	"\nMove range address",0
Compare_Usage	Equ	This Byte	; Compare command usage format string
		Db	"\nCompare range address",0
Search_Usage	Equ	This Byte	; Search command usage format string
		Db	"\nSearch range value[s]",0
Bpoint_Usage	Equ	This Byte	; Software breakpoint usage format
		Db	"\nBPoint<number> address <type>"
		Db	"\n     Where type is r, w, a, or e",0
Bdsable_Usage	Equ	This Byte	; Disable breakpoint usage format string
		Db	"\nBDisable breakpoint[s]",0
Benable_Usage	Equ	This Byte	; Enable breakpoint usage format string
		Db	"\nBEnable breakpoint[s]",0
Bclear_Usage	Equ	This Byte	; Clear breakpoint usage format string
		Db	"\nBClear breakpoint[s]",0
Blist_Usage	Equ	This Byte	; List breakpoint usage format string
		Db	"\nBlist <breakpoint[s]>",0
Proceed_Usage	Equ	This Byte	; Process command usage format string
		Db	"\nProceed <=address>",0
Flip_Usage	Equ	This Byte	; Flip command usage format string
		Db	"\nFLip",0
Continue_Fmt	Equ	This Byte	; Continue message format string
		Db	"Press any key to continue...\r",0
Diff_Arg	Equ	This Word	; Difference argument list
		Dw	Offset Current_Address
		Dw	Offset Value
		Dw	Offset Compare
		Dw	Offset Compare_Address
Diff_Fmt	Equ	This Byte	; Difference format string
		Db	"\n%04Xh %02tX - %02tX %04Xh",0
Find_Arg	Equ	This Word	; Find argument list
		Dw	Offset Compare_Address
Find_Fmt	Equ	This Byte	; Find format string
		Db	"\n%04Xh",0
Break_Arg	Equ	This Word	; Breakpoint argument list
		Dw	Offset Value
Break_Status	Dw	?
		Dw	Offset Break_Address
Break_Type	Dw	?
Break_Fmt	Equ	This Byte	; Breakpoint format string
		Db	"%2d) %s\t%04Xh\t%s\n",0
Enable_String	Db	"Enabled ",0
Disable_String	Db	"Disabled",0
Software_String Db	"Software",0
Illegal_String	Db	"Illegal ",0
Read_String	Db	"Read    ",0
Write_String	Db	"Write   ",0
Access_String	Db	"Access  ",0
Execute_String	Db	"Execute ",0
Exe_Help	Db	"X      Start Apple ][ execution     \n",0
Go_Help 	Db	"G      Start Apple ][ execution     \n",0
Print_Help	Db	"?      Evaluate the given expression\n",0
Eval_Help	Db	"EV     Evaluate the given expression\n",0
Dump_Help	Db	"D      Dump data in current format  \n",0
Dbyte_Help	Db	"DB     Dump data in byte format     \n",0
Dword_Help	Db	"DW     Dump data in word format     \n",0
Code_Help	Db	"U      Unassemble 65C02 code        \n",0
Reg_Help	Db	"R      Set register value           \n",0
Radix_Help	Db	"RA     Change default radix value   \n",0
Help_Help	Db	"H      Help system usage            \n",0
Trace_Help	Db	"T      Trace execution              \n",0
Enter_Help	Db	"E      Enter data values            \n",0
Ebyte_Help	Db	"EB     Enter data in byte format    \n",0
Eword_Help	Db	"EW     Enter data in word format    \n",0
Fill_Help	Db	"F      Fill memory                  \n",0
Move_Help	Db	"M      Move memory                  \n",0
Compare_Help	Db	"C      Compare memory               \n",0
Search_Help	Db	"S      Search for pattern           \n",0
Bpoint_Help	Db	"BP     Set debug breakpoint         \n",0
Bdsable_Help	Db	"BD     Disable breakpoint           \n",0
Benable_Help	Db	"BE     Enable breakpoint            \n",0
Bclear_Help	Db	"BC     Clear breakpoint             \n",0
Blist_Help	Db	"BL     List breakpoint              \n",0
Proceed_Help	Db	"P      Proceed with execution       \n",0
Flip_Help	Db	"FL     Flip to Apple ][ screen      \n",0
;******************************************************************************
;
;	Define all the needed tables
;
;******************************************************************************
Help_Table	Equ	This Word	; Debug help message table
		Dw	Exe_Help	; Execute command help message
		Dw	Go_Help 	; Go command help message
		Dw	Print_Help	; Print command (Evaluate) help message
		Dw	Eval_Help	; Evaluate command help message
		Dw	Dump_Help	; Dump data command help message
		Dw	Dbyte_Help	; Dump byte data command help message
		Dw	Dword_Help	; Dump word data command help message
		Dw	Code_Help	; Unassemble command help message
		Dw	Reg_Help	; Register command help message
		Dw	Radix_Help	; Radix command help message
		Dw	Help_Help	; Help command help message
		Dw	Trace_Help	; Trace command help message
		Dw	Enter_Help	; Enter command help message
		Dw	Ebyte_Help	; Enter byte data command help message
		Dw	Eword_Help	; Enter word data command help message
		Dw	Fill_Help	; Fill command help message
		Dw	Move_Help	; Move command help message
		Dw	Compare_Help	; Compare command help message
		Dw	Search_Help	; Search command help message
		Dw	Bpoint_Help	; Set breakpoint command help message
		Dw	Bdsable_Help	; Disable breakpoint help message
		Dw	Benable_Help	; Enable breakpoint help message
		Dw	Bclear_Help	; Clear breakpoint help message
		Dw	Blist_Help	; List breakpoint help message
		Dw	Proceed_Help	; Proceed command help message
		Dw	Flip_Help	; Flip command help message
		Dw	0000h		; End of the help message table
Usage_Table	Equ	This Word	; Debug usage message table
		Dw	Exe_Usage	; Execute command usage message
		Dw	Go_Usage	; Go command usage message
		Dw	Print_Usage	; Print command (Evaluate) usage message
		Dw	Eval_Usage	; Evaluate command usage message
		Dw	Dump_Usage	; Dump data command usage message
		Dw	Dbyte_Usage	; Dump byte data command usage message
		Dw	Dword_Usage	; Dump word data command usage message
		Dw	Code_Usage	; Unassemble command usage message
		Dw	Reg_Usage	; Register command usage message
		Dw	Radix_Usage	; Radix command usage message
		Dw	Help_Usage	; Help command usage message
		Dw	Trace_Usage	; Trace command usage message
		Dw	Enter_Usage	; Enter command usage message
		Dw	Ebyte_Usage	; Enter byte data command usage message
		Dw	Eword_Usage	; Enter word data command usage message
		Dw	Fill_Usage	; Fill command usage message
		Dw	Move_Usage	; Move command usage message
		Dw	Compare_Usage	; Compare command usage message
		Dw	Search_Usage	; Search command usage message
		Dw	Bpoint_Usage	; Set breakpoint command usage message
		Dw	Bdsable_Usage	; Disable breakpoint usage message
		Dw	Benable_Usage	; Enable breakpoint usage message
		Dw	Bclear_Usage	; Clear breakpoint usage message
		Dw	Blist_Usage	; List breakpoint usage message
		Dw	Proceed_Usage	; Proceed command usage message
		Dw	Flip_Usage	; Flip command usage message
;******************************************************************************
;
;	Define the end of the Apple Emulator Code Segment
;
;******************************************************************************
Emulate Ends
	End				; End of the message module
