;       Apple ][ 6502 emulator
;       by Steven E. Hugg
;
;       inquiries to: hugg@cs.fsu.edu

name	cpu
dosseg
NOWARN ALN
.model tpascal
.data
EXTRN	MemSeg:DWORD
EXTRN	RomPage:DWORD
EXTRN	LangPage:DWORD
EXTRN	CGAbuf:DWORD
EXTRN   old_int9:DWORD
EXTRN   Nybl:BYTE
EXTRN   NyblPtr:WORD
EXTRN	NumNybls:WORD
EXTRN   NyblTrack:BYTE
EXTRN   DirtyTrack:BYTE
.code
EXTRN	RWTS:NEAR
EXTRN	ProgMenu:FAR
EXTRN	MakeNibbles:FAR

;CGA	label near
LangRam	label near
;C386	label near
IFDEF C386
.386
ENDIF

;		*** EQUATES
acc	equ	cl
x	equ	dl
y	equ	dh
flags	equ	ch
@no	equ	cycl

overflow	equ	64
breakflag	equ	16
decmode		equ	8
irqdisable	equ	4
unusedflag	equ	32
allflags	equ	not (1+2+128)
orflags		equ	unusedflag+breakflag

even
IFDEF langram
RdMemMap	dw	128 dup (?)
WrMemMap	dw	128 dup (?)
IOmap		db	256 dup (?)
opcodes		equ	cs:opcodes_org
Mem		equ	es:0
ELSE
IOmap		equ	byte ptr ds:0ca00h
opcodes		equ	word ptr ds:0c800h
Mem		equ	ds:0
ENDIF
RESvector	equ	word ptr ds:0fffch
IRQvector	equ	word ptr ds:0fffeh

;		*** VARIABLES

old_int1	dd	?
;old_int9	dd	?
dsseg		dw	?
esseg		dw	?
IFDEF langram
langseg		dw	?
ENDIF
oldsp		dw	?
vidseg		dw	?
vidout		dw	?	;address of I/O routine
modenow		db	?
keyflag         db      ?
kbdlatch	db	?
vidmix		db	?	;bit 0: OFF=TEXT,ON=GR
				;bit 1: OFF=MIX,ON=NOMIX
				;bit 2: OFF=PAGE0,ON=PAGE1
				;bit 3: OFF=LORES,ON=HIRES


zero	macro	reg
	xor	reg,reg
	endm

@maketables:
	push	ds
	push	es
IFNDEF langram
	push	ds
        pop	es
        push	cs
        pop	ds
	mov	si,offset opcodes_org
	mov	di,offset opcodes
	mov	cx,256
	rep	movsw
ELSE
	push	cs
        pop	es
ENDIF

	xor	ax,ax
	mov	di,offset IOmap
	mov	cx,0c0h/2
	rep	stosw
	dec	ax
	mov	cx,040h/2
	rep	stosw

	xor	bx,bx
	mov	al,64
	mov	cx,64
@tblp2:
	mov	byte ptr cs:textchar[bx],al
	mov	byte ptr cs:textchar[bx+128],al
	mov	byte ptr cs:textchar[bx+256],al
	mov	byte ptr cs:textchar[bx+1],70h
	mov	byte ptr cs:textchar[bx+129],87h
	mov	byte ptr cs:textchar[bx+257],07h
	add	bx,2
	inc	al
	cmp	al,96
	jnz	@tbsk1
	mov	al,32
@tbsk1:
	loop	@tblp2
	mov	bx,160*2
	mov	al,32
	mov	cx,96
@tblp3:
	mov	byte ptr cs:textchar[bx],al
	mov	byte ptr cs:textchar[bx+1],07h
	add	bx,2
	inc	al
	loop	@tblp3
	mov	byte ptr cs:textchar[192],0dbh

        pop     es
        pop     ds
	ret

;		INT1RTN - single-step interrupt
int1rtn:
	push	bp
	mov	bp,sp
	cmp	word ptr [bp+4],@code
	je	trapper
;	jne	notrap
;	cmp	word ptr [bp+2],offset process
;	jb	notrap
;	cmp	word ptr [bp+2],offset process_end
;	ja	trapper
notrap:
	pop	bp
	iret
trapper:
	and	word ptr [bp+6],not 100h
	pop	bp
	add	sp,4
	popf
	lds	dx,old_int1
	mov	ax,2501h
	int	21h
	mov	ds,dsseg
        mov     es,esseg
        mov     sp,oldsp
	jmp	getkeyflag

quitkey:
	mov	keyflag,ah
	push	di
	push	dx
	mov	di,offset old_int1
	mov	dx,offset int1rtn
	mov	al,1
	call	@setintnum
	pop	dx
	pop	di
	pop	ax
	push	bp
	mov	bp,sp
	or	word ptr [bp+6],100h	;set trap flag
	pop	bp
	iret

;		INT9RTN - interrupt when key pressed

ConvExtKey	macro	key,cvtkey
LOCAL	@notkey
	cmp	ah,key
	jne	@notkey
	mov	al,cvtkey
	jmp	short noextkey
@notkey:
		endm

PUBLIC	Int9Rtn

Int9Rtn	proc
	cli
	push	ax
	push	ds
	mov	ax,@data
	mov	ds,ax
	pushf
	call	old_int9
	pop	ds
	mov	ah,1
	int	16h
	jz	int_nokey
	xor	ah,ah
	int	16h
	or	al,al
	jne	noextkey
	cmp	ah,2dh		;Alt-X { 10h is alt-Q }
	je	quitkey
	cmp	ah,13h		;Alt-R
	je	quitkey
	cmp	ah,19h		;Alt-P
	je	quitkey
	cmp	ah,44h		;F10
	jne	notf10key
	pushf
	call	ProgMenu
	jmp	short int_nokey
notf10key:
ConvExtKey	4Bh,8		;Left Arrow -> ^H
ConvExtKey	4Dh,21		;Right Arrow -> ^U
ConvExtKey	48h,11		;Up Arrow -> ^K
ConvExtKey	50h,10		;Down Arrow -> ^J
	jmp	short int_nokey
noextkey:
	or	al,80h
	mov	kbdlatch,al
int_nokey:
	pop	ax
	iret
Int9Rtn	endp

@setintnum:
	push	bx
	push	es
	push	ds
	mov	ah,35h
	int	21h
	mov	word ptr cs:[di],bx
	mov	word ptr cs:[di+2],es
	mov	bx,cs
	mov	ds,bx
	mov	ah,25h
	int	21h
	pop	ds
	pop	es
	pop	bx
	ret
@setinterrupts:
	mov	di,offset old_int9
	mov	dx,offset int9rtn
	mov	al,9
;	call	@setintnum
	ret
@clearinterrupts:
	mov	di,ds
	lds	dx,old_int9
	mov	ax,2509h
;	int	21h
	mov	ds,di
	ret

@setupmouse:
	xor	ax,ax
	int	33h		;init mouse
	inc	ax
	jne	@nomouse
@redomouse:
	mov	cx,3		;step ratio
	mov	dx,cx
	mov	al,15
	int	33h
	xor	cx,cx		;min
	mov	dx,255*8	;max
	mov	al,7
	int	33h		;Set X
	inc	al
	int	33h		;Set Y
@nomouse:
	ret

;		----- MACROS -----
;		CYCLE - process next instruction
;
;  NOTE: if operand is zero page or last instruction's code < 80h, bh = 0.

Cycle	macro	isbh0
	lodsb
	mov	bl,al
  IFB	<isbh0>
	zero	bh
  ENDIF
IFDEF C386
	jmp	word ptr opcodes[ebx*2]
ELSE
	shl	bx,1
	jmp	word ptr opcodes[bx]
ENDIF
	endm

Cycle2	macro	isbh0
	Cycle	isbh0
	endm
;

process	PROC NEAR

PUBLIC	process

	push	bp
	mov	bp,sp
	push	ds
	mov	oldsp,sp
IFDEF langram
	mov	ax,word ptr LangPage+2
	sub	ax,0d00h
	mov	langseg,ax
ENDIF
	mov	ax,word ptr MemSeg+2
	mov	dsseg,ax
	mov	ds,ax
IFDEF C386
	xor	ebx,ebx
ENDIF
	call	@setinterrupts
	call	@maketables
	call	@setupmouse

power_reset:
	mov	kbdlatch,0
	mov	es,dsseg
	mov	cx,0c000h/2
	xor	ax,ax
	mov     di,ax
	rep stosw
	IFDEF langram
	push	cs
	pop	es
	mov	ax,@data
	mov	ds,ax
	mov	di,offset RdMemMap
	mov	cx,128+128
	mov	ax,dsseg
	rep	stosw
;	add	di,16
;	mov	cx,24
;	mov	ax,langseg
;	rep	stosw
        ENDIF
	mov	ds,dsseg
	mov	modenow,255
	call	draw_screen
doreset:
	xor	ax,ax
	xor	cx,cx
	xor	dx,dx			;set regs to zero
	mov	flags,orflags
	clc
	cld
	mov	bp,01FFh		;set stack ptr to $ff
	mov	si,RESvector 		;reset program counter

cycl:
	lodsb
	mov	bl,al
	zero	bh
	shl	bx,1
	jmp	word ptr opcodes[bx]

getkeyflag:			;special key pressed
	mov	al,keyflag
	mov	keyflag,0
	cmp	al,2dh
	je	endprocess	;Alt-Q
	cmp	al,13h
	je	doreset
	cmp	al,19h
	je	power_reset
	jmp	cycl

endprocess:
	call	@clearinterrupts
	mov	ax,3
	int	10h
	mov	sp,oldsp
	pop	ds
	pop	bp
	ret

process endp

;	***********************
;	*   INSTRUCTION SET   *
;	***********************
;
INCLUDE	6502.INC

process_end:

IOB0	db	1,60h,1,0,0,0,0,0,0,8,0,0,1,0,0,0,0,0	;IOB table
sectran db	0,7,14,6,13,5,12,4,11,3,10,2,9,1,8,15	;sector translation for boot

@37:			;special instruction
	lodsb
	cmp	al,73h	;next byte has to be this
	je	doextrn
	Cycle2	bh0
doextrn:
	push	ax
	lodsb
	cmp	al,5
	ja	ext_cycl
	mov	bl,al
	zero	bh
	shl	bx,1
	jmp	word ptr cs:ext_codes[bx]
ext_cycl:
	pop	ax
	jmp	cycl
ext_kbd:
	mov	ah,0
	int	16h
	or	al,80h
	mov	acc,al
	jmp	ext_cycl
ext_disk:
	push	cx
	push	dx
	push	bp
	push	si
	push	es
	push	ds
	mov	bl,y
	mov	bh,acc
IFDEF langram
	mov	di,bx
	mov	bl,bh
	and	bx,0feh
	mov     bx,[RdMemMap+bx]
	push	bx		;SEG
	push	di		;OFS
ELSE
	push	ds		;IOB segment
	push	bx		;IOB offset
ENDIF
;	mov	al,byte ptr [bx+4]
;	shl	al,1
;	mov	cs:byte ptr thistrk,al
;	mov     ds:byte ptr [478h],al
	mov	cx,@data
	mov	ds,cx
	call	RWTS
rwtsexit:
	pop	ds
	pop	es
	pop	si
	pop	bp
	pop	dx
	pop	cx
	mov	bl,al
	pop	ax
	and	ah,254		;clear carry
	or	bl,bl
	jz	norwtserr
	or	ah,1		;set carry
norwtserr:
	jmp	cycl
ext_trak0:
	push	cx
	push	dx
	push	bp
	push	si
	push	es
	push	ds
	mov	IOB0[1],x		;slot
IFDEF langram
	mov	es,[RdMemMap]
ENDIF
	mov	bl,byte ptr [Mem+3dh]
	mov	bh,0
	mov	al,sectran[bx]
	mov	IOB0[5],al		;sector
	mov	ax,word ptr [Mem+26h]
	mov	word ptr IOB0[8],ax	;buffer
	mov	ax,offset IOB0
	push	cs		;IOB seg
	push	ax		;IOB offset
	mov	cx,@data
	mov	ds,cx
	call	RWTS
	jmp	rwtsexit
ext_mouse:
	push	ax
	push	cx
	push	dx
	push	dx
	mov	ax,3
	int	33h
	pop	bx
	or	bl,bl	;x
	jz	extpdl0
	mov	cx,dx
extpdl0:
	shr	cx,1
	shr	cx,1
	shr	cx,1
	mov	al,cl
	pop	dx
	pop	cx
	mov	y,al
	pop	ax
	jmp	cycl

ext_codes:
	dw	ext_cycl,ext_kbd,ext_cycl,ext_disk,ext_trak0
	dw	ext_mouse

;		*** I/O HANDLERS

RandIOret:
	in	al,40h
	mov	byte ptr [Mem+bx],al
IOret:
	ret

hiresofs:
IFNDEF CGA
	dw	2 dup (0),2 dup (40),2 dup (80),2 dup (120)
	dw	2 dup (160),2 dup (200),2 dup (240),2 dup (280)
	dw	2 dup (0+2000h),2 dup (40+2000h),2 dup (80+2000h),2 dup (120+2000h)
	dw	2 dup (160+2000h),2 dup (200+2000h),2 dup (240+2000h),2 dup (280+2000h)
ELSE
REPT 2
	dw	2 dup (0),2 dup (2000h),2 dup (80),2 dup (80+2000h)
	dw	2 dup (160),2 dup (160+2000h),2 dup (240),2 dup (240+2000h)
ENDM
ENDIF

; ROUTINE TO DRAW TEXT ON TEXT SCREEN

textvid:
	mov	al,[Mem+bx]
IFDEF langram
	mov	es,vidseg
ENDIF
	and	bh,3
	shl	bx,1
	mov	di,word ptr cs:textlkup[bx]
	shl	di,1
	js	textskip
	mov	bl,al
	zero	bh
	shl	bx,1
	mov	bx,word ptr cs:textchar[bx]
	mov	word ptr es:[di],bx
textskip:
	ret

; MACROS FOR HI-RES GRAPHICS

IFNDEF CGA	; FOR EGA ONLY
HiresSub	macro
LOCAL	hiresodd
	push	bx
	mov	al,byte ptr [bx-1]
	mov	bx,word ptr [bx]
	shl	al,1
	shl	al,1
	rcl	bx,1
        shl     al,1
        rcl     bx,1
	and	bx,0fffh
	test	di,1
	jnz	hiresodd
	add	bx,1000h
hiresodd:
	mov	al,es:[4000h+bx]
	stosb
	pop	bx
	endm
ELSE
HiresSub	macro
LOCAL	hiresodd
	push	bx
	mov	al,byte ptr [bx-1]
	mov	bx,word ptr [bx]
	shl	al,1
	shl	al,1
	rcl	bx,1
	and	bx,03ffh
	test	di,2
	jnz	hiresodd
	add	bx,400h
hiresodd:
	shl	bx,1
	mov	bx,word ptr [cs:CGAlkup+bx]
	mov	word ptr es:[di],bx
	add	di,2
	pop	bx
	endm
ENDIF

hireskip:
	mov	bx,cx
	pop	cx
	ret
hiresmix:
	cmp	di,40*20*8
	jb	hireskip
	mov	bx,cx
	mov	al,[Mem+bx]
	call	loresmix
	jmp	hireskip

; ROUTINE TO DRAW HI-RES GRAPHICS
hiresvid:
	push	cx
	mov	cx,bx
	and	bh,3
	shl	bx,1
	mov	di,word ptr cs:lorslkup[bx]
	or	di,di
	js	hireskip
	cmp	ch,0ch
	jb	hiresmix
	cmp	di,40*20*8
	jb	hires1
	test	vidmix,2	;in mix mode?
	jz	hireskip	;if so, don't draw
hires1:
IFDEF langram
	push	ds
	mov	ds,dsseg
	mov	es,vidseg
ENDIF
	mov	bl,cl
	zero	bh
	mov	al,byte ptr cs:boundlkup[bx]
	mov	bl,ch
	sub	bl,20h
	and	bl,not 1
	add	di,word ptr cs:hiresofs[bx]
	mov	bx,cx
	mov	cl,al
	cmp	cl,1
	je	hileftbound
IFDEF CGA
	sub	di,2
ELSE
	dec	di
ENDIF
        dec     bx
	HiresSub
	inc     bx
hileftbound:
	HiresSub
	cmp     cl,2
	je	hirightbound
        inc     bx
	HiresSub
	dec	bx
hirightbound:
IFDEF langram
	pop	ds
ENDIF
	pop	cx
	ret

; ROUTINE TO DRAW LO-RES GRAPHICS ON HI-RES SCREEN

loresvid:
	mov	al,[Mem+bx]
	and	bh,3
	shl	bx,1
	mov	di,word ptr cs:lorslkup[bx]
	or	di,di
	js	loreskip
	cmp	di,40*20*8
	jb	lores1
	test	vidmix,2
	jne	lores1

	call	loresmix
IFNDEF CGA
	push	dx
	mov     dx,3ceh
	mov	ax,205h
	out	dx,ax
	pop	dx
ENDIF
	ret
lores1:
IFDEF langram
	mov	es,vidseg
ENDIF
	mov	bx,offset LoResColorMap
	push	ax
	and	al,15		;1st nibble
	xlat	cs:LoResColorMap
	REPT	4
	stosb
	add	di,39
	ENDM
	pop	ax
	REPT	4
	shr	al,1
	ENDM
	xlat	cs:LoResColorMap
	REPT	4
	stosb
	add	di,39
	ENDM
loreskip:
	ret



loresmix:
	mov	bl,al
	zero	bh
	shl	bx,1
	mov	bl,byte ptr cs:textchar[bx]
	and	bx,7fh
	shl	bx,1
	shl	bx,1
	shl	bx,1
	add	bx,0fa6eh 	;character table in BIOS
	push	si
	push	ds
IFNDEF CGA
	push	dx
	push	ax
	mov	dx,03ceh
	mov	ax,5
	out	dx,ax
ENDIF
	mov	si,bx
	mov	bx,0f000h
	mov	ds,bx
IFDEF langram
	mov	es,vidseg
ENDIF
IFDEF CGA
	REPT	4
	movsb
	add	di,2000h-1
	movsb
	sub	di,2000h-79
	ENDM
ELSE
	REPT	8
	movsb
	add	di,39
	ENDM
	inc	ah
	out	dx,ax
	pop	ax
	pop	dx
ENDIF
	pop	ds
	pop	si
	ret

;	SCREEN-SETTING ROUTINES

setmapes	macro
IFDEF langram
	mov	ax,cs
ELSE
	mov	ax,ds
ENDIF
	mov	es,ax
endm

map_gr_page:
	setmapes
	mov	di,offset IOmap+4
	xor	ax,ax
	mov	cx,4
	rep	stosw
	dec	ax
	test	vidmix,2	;see if mixed mode
	jnz	@mixmap
	mov	bl,vidmix
	and	bx,4
	add	bl,6
	mov	word ptr IOmap[bx],ax
@mixmap:
	ret

map_text_page:
	setmapes
	xor	ax,ax
	mov	di,offset IOmap+20h
	mov	cx,20h
	rep	stosw
	test	vidmix,4	;which page?
	jnz	mappg1		;page 2
	dec	ax
mappg1:
	mov	di,offset IOmap+4h
	stosw
	stosw
	not	ax
	stosw
	stosw
	ret

changemode:
	mov	bx,0b800h
IFNDEF	CGA
	cmp	al,12
	jb	notegamode
	mov	bh,0a0h
notegamode:
ENDIF
	mov	es,bx
	mov	esseg,bx
        mov     vidseg,bx
	cmp	al,modenow
	je	nochngmode
	mov	modenow,al
	xor	ah,ah
IFNDEF CGA
	or	al,80h
ENDIF
	int	10h
	call	@redomouse
nochngmode:
	ret

flip_page:
IFNDEF CGA
	test	vidmix,1
	jz	draw_screen
	test	vidmix,8
	jz	draw_screen
	push	ax
	push	dx
	mov	dx,3d4h
	mov	ax,0Ch
	test	vidmix,4
	jz	flippg1
	mov	ah,20h
flippg1:
	out	dx,ax
	pop	dx
	pop	ax
	ret
ENDIF

draw_screen:
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	mov	al,vidmix
	test	al,1
	jnz	drawgr
	jmp	drawtext
drawgr:
	test	al,8
	jz	drawlores
	jmp	short drawhires
drpgr_end:
	mov	di,40*24*8
	mov	cx,20*8
	xor	ax,ax
	rep	stosw
	test	vidmix,2
	jnz	drpg_end
	call	@drawtextbot
drpg_end:
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret

drawlores:
IFNDEF CGA
	mov	al,13
	call	changemode
	mov	dx,3ceh
	mov	ax,205h
	out	dx,ax
	mov	ax,0ff08h
	out	dx,ax
	mov	dx,3d4h
ELSE
	mov	al,4
	call	changemode
ENDIF
	mov	vidout,offset loresvid
	call	@drawtextpage
	jmp	drpgr_end

drawhires:
	call	map_gr_page
	mov	di,offset IOmap+20h
	mov	ax,0ffffh
	mov	si,2000h
IFDEF CGA
	test	vidmix,4
	jz	@hipg1
	mov	si,4000h
	inc	ax
@hipg1:
	mov	cx,10h
	rep	stosw
	not	ax
	mov	cx,10h
	rep	stosw
	mov	al,4
	call	changemode
ELSE
	mov	cx,20h
	rep	stosw
	mov	al,13
	call	changemode
	call	flip_page
	mov	ax,105h
	mov	dx,3ceh
	out	dx,ax
ENDIF
	mov	vidout,offset hiresvid
	xor	di,di
	mov	bx,si
        call    refresh_hires
IFNDEF CGA
        mov     di,2000h
        mov     bx,4000h
        call    refresh_hires
	mov	al,byte ptr [es:4000h]
	mov	di,40*24*8
	mov	cx,20*8
	rep	stosw
	mov	di,40*24*8+2000h
	mov	cx,20*8
	rep	stosw
ENDIF
	jmp	drpgr_end

refresh_hires:
IFDEF langram
	push	ds
	mov	ds,[RdMemMap+20h]
ENDIF
@@lptxt23:
	mov	dl,8
@@lptxt22:
	mov	dh,8
@@lptxt21:
        mov     cx,40
@@lptxt2:
	HiresSub
	inc	bx
	loop	@@lptxt2
IFDEF CGA
	xor	di,2000h
	test	di,2000h
	jz	@@lpcga
	sub	di,80
@@lpcga:
ENDIF
	add     bx,400h-40
	dec	dh
	jne	@@lptxt21
	sub	bx,2000h-80h
	test	vidmix,2
	jnz	@@lpnomix
	push	bx
	and	bx,1fffh
	cmp	bx,250h
	pop	bx
	je	@@lpendit
@@lpnomix:
	dec	dl
	jne	@@lptxt22
	sub	bx,400h-40
	cmp	bl,78h
	jne	@@lptxt23
@@lpendit:
IFDEF langram
	pop	ds
ENDIF
	ret

drawtext:
	xor	al,al
	call	changemode
	mov	ah,2
	zero	bh
	mov	dx,0ffffh
	int	10h
	mov	vidout,offset textvid
	call	@drawtextpage
	mov	di,80*24
	mov	cx,40
	xor	ax,ax
	rep	stosw
	jmp	drpg_end

@drawtextpage:
	push	es
	call	map_text_page
	pop	es
	mov	cx,400h
	mov	bh,4
	test	vidmix,4
	je	settpag
	mov	bh,8
settpag:
	xor	bl,bl
	mov	si,bx
@lptxt:	mov	bx,si
IFDEF langram
	mov	es,RdMemMap[4]
ENDIF
	call	vidout
	inc	si
	loop	@lptxt
	ret

@drawtextbot:
	test	vidmix,8
	jz	splegu
	push	es
	call	map_gr_page
	pop	es
splegu:
	mov	bx,650h
	test	vidmix,4
	je	settpag1
	add	bh,4
settpag1:
	mov	si,bx
REPT	4
LOCAL	@lptxt1
	mov	cx,28h
@lptxt1:
	mov	bx,si
IFDEF langram
	mov	es,RdMemMap[4h]
ENDIF
	call	loresvid
	inc	si
	loop	@lptxt1
	add	si,80h-28h
ENDM
	ret

bitchng macro	lab,state,bit
lab:	test	vidmix,bit
IF state
	jnz	bitret		;if bit = 1, exit
ELSE
	jz	bitret		;if bit = 0, exit
ENDIF
	xor	vidmix,bit
	endm

bitchng grmode,1,1
	jmp	draw_screen

bitchng txmode,0,1
	jmp	draw_screen

bitchng nomix,1,2
	test	vidmix,1	;is graphics mode?
	jz	bitret
	jmp	draw_screen

bitchng	mix,0,2
	test	vidmix,1	;is graphics mode?
	jz	bitret
	push	ax
	push	bx
	push	cx
	push	si
	call	@drawtextbot
	pop	si
	pop	cx
	pop	bx
	pop	ax
bitret:	ret

bitchng page0,0,4
	jmp	flip_page

bitchng page1,1,4
	jmp	flip_page

bitchng lores,0,8
	test	vidmix,1	;is graphics mode?
	jz	bitret
	jmp	draw_screen

bitchng hires,1,8
	test	vidmix,1	;is graphics mode?
	jz	bitret
	jmp	draw_screen

PURGE	bitchng

;	OTHER I/O STROBES

clearstrobe:
	and	kbdlatch,07fh
kbdin:
	mov	al,kbdlatch
	mov	[Mem+bx],al
	ret

spkrout:
	test    byte ptr ds:0c030h,1
	jne	nospkr
	in	al,61h
	xor	al,2
	out	61h,al
nospkr:
	ret

IRP	N,<1,2,4,8>
	LOCAL	nogame
gc&N&:
	mov	di,dx
	mov	dx,201h
	in	al,dx
	and	al,N
	jz	nogame
	or	al,80h
nogame:	mov	[Mem+bx],al
	mov	dx,di
	ret
ENDM

btnmask	db	1,2,4
joybtnmask      db   16,32,64
gamebtn:
; this code segment for joystick reading
        push    dx
        push    bx
        mov     dx,201h
        out     dx,al
        in      al,dx
        and     bx,3
        test    al,cs:joybtnmask-1[bx]
        pop     bx
        pop     dx
        jnz     nogamebut
        jmp     yagamebut

; this code segment for mouse reading
	push	bx
	push	ax
	mov	ax,3
	int	33h
	pop	ax
	mov	al,bl
	pop	bx
	mov	di,bx
	and	di,3
	test	al,cs:btnmask[di-1]
	jz	nogamebut
yagamebut:
	call	RandIOret
	or	al,80h
	jmp	short yesgamebut
nogamebut:
	call	RandIOret
	and	al,7fh
yesgamebut:
	mov	[Mem+bx],al
	ret

gmstrobe:
	push	dx
	mov	dx,201h
	out	dx,al
	pop	dx
	jmp	RandIOret

phaseup	db	3,5,7,1
phasedn	db	7,1,3,5
lastphase	db	0
thistrk         db      0
diskphase:
	test	bl,1
	jnz	phzodd		;skip if adr. is odd
	test	lastphase,1
	jz	phzodd		;skip if last adr is even
	mov	di,bx
	and	di,7
	shr	di,1
	mov	al,lastphase
        and     al,7
	cmp	al,phaseup[di]
	jne	@@phz1
	cmp	thistrk,35*2
	jae	@@phz2
	inc     thistrk
	jmp	short @@phz2
@@phz1:	cmp	al,phasedn[di]
	jne	@@phz2
	cmp	thistrk,0
	je	@@phz2
	dec	thistrk
@@phz2:
phzodd:
	mov	lastphase,bl
	jmp	RandIOret

valid   db      0
diskrd:
	push	ds
	mov     di,@data
	mov	ds,di
	mov	al,thistrk
	cmp	al,NyblTrack
	je	@@dwd0
	mov	NyblTrack,al
	pushf
	call	MakeNibbles
@@dwd0:
	mov	di,NyblPtr
	cmp	di,NumNybls
	jb	@@dwd1
	xor	di,di
@@dwd1:
IFDEF   disknoise
	call	spkrout
ENDIF
	mov	al,byte ptr Nybl[di]
	inc	valid
	cmp	valid,4
	jb	@@drd2
	and     al,0fh
	mov	valid,0
	dec	di
@@drd2:
	inc	di
	mov	NyblPtr,di
	pop	ds
	mov	[Mem+bx],al
	ret

diskwr:
	push	ds
	mov     di,@data
	mov	ds,di
	mov	al,thistrk
	cmp	al,NyblTrack
	je	@@drd0
	mov	NyblTrack,al
	pushf
	call	MakeNibbles
@@drd0:
	mov	di,NyblPtr
	cmp	di,NumNybls
	jb	@@drd1
	xor	di,di
@@drd1:
IFDEF   disknoise
	call	spkrout
ENDIF
	mov	byte ptr Nybl[di],al
	inc	di
	mov	NyblPtr,di
        mov     DirtyTrack,1
	pop	ds
        call    RandIORet
	ret

IFDEF langram

; LANG-CARD ROUTINES

langwrit	db	0
langrtn:
	push	ax
	push	cx
	push	dx

	mov	ax,cs
	mov	es,ax
	zero	cx
	mov	dx,langseg
        test	bl,8
	jz	bank2
	add	dx,300h		; select bank 1
bank2:
	mov	di,offset RdMemMap+0d0h
	mov	al,bl
	inc	al
	test	al,2		; read ram?
	jnz	@@rdrom		; no, read rom

        call	langmap		; select RAM card
	jmp	short @@rdram
@@rdrom:
	mov	ax,dsseg
	mov	cx,30h/2
	rep stosw
@@rdram:
	mov	di,offset WrMemMap+0d0h
	test	bl,1
        jnz	@@wrram		; write RAM

        mov	langwrit,0
@@wrprotect:
	mov	ax,dsseg
        mov	cl,30h/2
        rep stosw
        mov	ax,0ffffh
        jmp	short @@endwrram
@@wrram:
	cmp	langwrit,0
        mov	langwrit,1
	je	@@wrprotect
        call	langmap		; write-enable RAM card
        xor	ax,ax
@@endwrram:
	mov	di,offset IOmap+0d0h
        mov	cl,30h/2
        rep stosw
@@endlang:
	loadnewip 1
	pop	dx
	pop	cx
	pop	ax
	ret
langmap:
        mov	ax,dx
        mov	cl,10h/2
        rep stosw
	mov	ax,langseg
        mov	cl,20h/2
        rep stosw
        ret

ENDIF ;langram

; DWDUP - creates <num> instances of word <v>
dwdup	macro	num,v
REPT	num
	dw	&v&
ENDM
endm

even
IOpage:
	dwdup	16,kbdin		;key input
	dwdup	16,clearstrobe
	dwdup	16,RandIORet		;cassette out
	dwdup	16,spkrout
	dwdup	16,RandIORet		;utility strobe
	dw	grmode,txmode
	dw	nomix,mix
	dw	page0,page1
	dw	lores,hires
	dwdup	8,RandIORet			;annunciators
REPT	2
	dw	RandIORet			;cassette in
	dwdup	3,gamebtn			;paddle buttons
	dw	gc1,gc2,gc4,gc8			;game controllers
ENDM
	dwdup	16,gmstrobe		;game strobes
IFDEF langram
	dwdup	16,LangRtn
ELSE
	dwdup	16,RandIORet		;lang. card
ENDIF
	dwdup	16,RandIORet		;slot 1
	dwdup	16,RandIORet		;slot 2
	dwdup	16,RandIORet		;slot 3
	dwdup	16,RandIORet		;slot 4
	dwdup	16,RandIORet		;slot 5
;	dwdup	16,RandIORet		;slot 6
	dwdup	8,diskphase
	dwdup	4,RandIORet
	dw	diskrd,RandIORet,RandIORet,diskwr
	dwdup	16,RandIORet		;slot 7

even
doIO:
IFDEF langram
	mov	es,RdMemMap[0c0h]
ENDIF
	mov	di,bx
	and	di,0ffh
	shl	di,1
	jmp	word ptr cs:IOpage[di]

storebyte	PROC NEAR adr,val:WORD
PUBLIC storebyte

	push	di
	push	ds
	push	es
	mov	ds,dsseg
	mov	es,esseg
	mov	cx,val
	mov	bx,adr
	mov	al,bh
	mov	di,ax
	and	di,0feh
	IFDEF langram
	mov	es,word ptr WrMemMap[di]
	ENDIF
	test	byte ptr IOmap[di],255
	jnz	@2fish
	mov	[Mem+bx],cl
stobend:
	pop	es
	pop	ds
	pop	di
	ret
@2fish:	cmp	bh,0c0h
	je	@2IO
	ja	stobend
	mov	[Mem+bx],cl
	call	vidout
	jmp	stobend
@2IO:	call	near ptr doIO
	jmp	stobend

storebyte	ENDP

;	VARIOUS LOOKUP TABLES & SUCH

even
textlkup:
	INCLUDE textlkup.tbl
lorslkup:
IFNDEF CGA
	INCLUDE lorslkup.tbl
ELSE
	INCLUDE cgalkup.tbl
ENDIF
graflkup:
	INCLUDE graflkup.tbl
boundlkup:
REPT 2
	db	1,38 dup (0),2
	db	1,38 dup (0),2
	db	1,38 dup (0),2
	db      8 dup (0)
ENDM
even
textchar:
	dw	256 dup (?)
;LoResPaletteMap db	0,4,1,53,2,7,15,47,6,46,7,39,58,55,31,63,0
LoResColorMap	db	0,4,1,5,2,7,3,9,6,12,7,13,10,14,11,15

IFDEF CGA
CGAlkup	proc
	dw	1000h dup (?)
CGAlkup	endp
PUBLIC CGAlkup
ENDIF

end
