;       6502 emulator instruction opcodes
;       by Steven E. Hugg
;
;       inquiries to: hugg@cs.fsu.edu


;		*** INDEX FOR OPCODES

even
opcodes_org:
	dw	@0,@1,@no,@no,@no,@5,@6,@no,@8,@9,@a,@no,@no,@d,@e,@no
	dw	@10,@11,@no,@no,@no,@15,@16,@no,@18,@19,@no,@no,@no,@1d,@1e,@no
	dw	@20,@21,@no,@no,@24,@25,@26,@no,@28,@29,@2a,@no,@2c,@2d,@2e,@no
	dw	@30,@31,@no,@no,@no,@35,@36,@37,@38,@39,@no,@no,@no,@3d,@3e,@no
	dw	@40,@41,@no,@no,@no,@45,@46,@no,@48,@49,@4a,@no,@4c,@4d,@4e,@no
	dw	@50,@51,@no,@no,@no,@55,@56,@no,@58,@59,@no,@no,@no,@5d,@5e,@no
	dw	@60,@61,@no,@no,@no,@65,@66,@no,@68,@69,@6a,@no,@6c,@6d,@6e,@no
	dw	@70,@71,@no,@no,@no,@75,@76,@no,@78,@79,@no,@no,@no,@7d,@7e,@no
	dw	@no,@81,@no,@no,@84,@85,@86,@no,@88,@no,@8a,@no,@8c,@8d,@8e,@no
	dw	@90,@91,@no,@no,@94,@95,@96,@no,@98,@99,@9a,@no,@no,@9d,@no,@no
	dw	@a0,@a1,@a2,@no,@a4,@a5,@a6,@no,@a8,@a9,@aa,@no,@ac,@ad,@ae,@no
	dw	@b0,@b1,@no,@no,@b4,@b5,@b6,@no,@b8,@b9,@ba,@no,@bc,@bd,@be,@no
	dw	@c0,@c1,@no,@no,@c4,@c5,@c6,@no,@c8,@c9,@ca,@no,@cc,@cd,@ce,@no
	dw	@d0,@d1,@no,@no,@no,@d5,@d6,@no,@d8,@d9,@no,@no,@no,@dd,@de,@no
	dw	@e0,@e1,@no,@no,@e4,@e5,@e6,@no,@e8,@e9,@ea,@no,@ec,@ed,@ee,@no
	dw	@f0,@f1,@no,@no,@no,@f5,@f6,@no,@f8,@f9,@no,@no,@no,@fd,@fe,@no

even
phptbl	db	0,2,128,2+128,1,1+2,1+128,1+2+128
plptbl	db	0,128,1,1+128,64,64+128,64+1,64+128+1

;IOwe	macro
;	mov	di,bx
;	and	di,0ffh
;	shl	di,1
;	call	word ptr cs:IOpage[di]
;	endm

;		CHKRTN - check locations for store instructions

chkrtn	macro	oper,flag
	LOCAL	@fish,@IO,@stor,nofish
IFNB	<oper>
	mov	al,bh
	mov	di,ax
	and	di,0feh
	IFDEF langram
	mov	es,word ptr WrMemMap[di]
	ENDIF
	test	byte ptr IOmap[di],255
	jnz	@fish
IFB	<flag>
	oper
ELSE
	sahf
	oper
	lahf
ENDIF
	Cycle

@fish:	cmp	bh,0c0h
	je	@IO
	ja	nofish
IFB	<flag>
	oper
ELSE
	sahf
	oper
	lahf
ENDIF
	call	vidout		;screen location
	jmp	near ptr cycl
@IO:	call    near ptr DoIO	;IO location
nofish:	jmp	near ptr cycl	;read-only location
ENDIF
	endm

;		IFIO - macro

ifio	macro	oper
	LOCAL	@fesh,@lohd
	cmp	bh,0c0h
	je	@fesh
IFDEF langram
	mov	al,bh
	mov	di,ax
	and	di,0feh
	mov	es,word ptr RdMemMap[di]
ENDIF
@lohd:
	oper
	Cycle
@fesh:	call	near ptr DoIO
	jmp	@lohd
	endm


;		ADDRESSING MODES -

loadnewip	macro savebx
IFDEF langram
IF savebx
	mov	di,bx
ENDIF
	mov	bx,si
	mov	bl,bh
	and	bx,0feh
	mov	ds,[RdMemMap+bx]
IF savebx
	mov	bx,di
ENDIF
ENDIF
	endm
loadzpes	macro
IFDEF langram
	mov	es,[RdMemMap]
ENDIF
	endm

getimm	macro
	lodsb
	endm
getzp	macro	isbh0		;lda aa
	lodsb
IFB	<isbh0>
	zero	bh
ENDIF
	mov	bl,al
	loadzpes
	endm
getzpx	macro	isbh0		;lda aa,x
	lodsb
	add	al,x
IFB	<isbh0>
	zero	bh
ENDIF
	mov	bl,al
	loadzpes
	endm
getzpy	macro	isbh0		;lda aa,y
	lodsb
	add	al,y
IFB	<isbh0>
	zero	bh
ENDIF
	mov	bl,al
	loadzpes
	endm

getabs	macro	oper,f		;lda aaaa
	mov	bx,[si]
	add	si,2
	chkrtn	<oper>,<f>
	endm
getabsx	macro	oper,f		;lda aaaa,x
	mov	bx,[si]
	add	si,2
	add	bl,x
	adc	bh,0
	chkrtn	<oper>,<f>
	endm
getabsy	macro	oper,f			;lda aaaa,y
	mov	bx,[si]
	add	si,2
	add	bl,y
	adc	bh,0
	chkrtn	<oper>,<f>
	endm
getindx	macro	isbh0,oper,f		;lda (aa,x)
IFB	<isbh0>
	zero	bh
ENDIF
	mov	bl,[si]
	inc	si
	add	bl,x
	loadzpes
	mov	bx,[Mem+bx]
	chkrtn	<oper>,<f>
	endm
getindy	macro	isbh0,oper,f		;lda (aa),y
IFB	<isbh0>
	zero	bh
ENDIF
	mov	bl,[si]
	inc	si
	loadzpes
	mov	bx,[Mem+bx]
	add	bl,y
	adc	bh,0
	chkrtn	<oper>,<f>
	endm
getind	macro	isbh0,oper,f		;lda (aa) (65C02 only)
IFB	<isbh0>
	zero	bh
ENDIF
	mov	bl,[si]
	inc	si
	loadzpes
	mov	bx,[Mem+bx]
	chkrtn	<oper>,<f>
	endm

;		MISC. MACROS -

movor	macro	z		;move [Mem+bx] to z, compare
	mov	z,[Mem+bx]
	sahf
	inc	z
	dec	z
	lahf
	endm
pushon	macro	z		;push z on stack
	mov	bx,bp
	loadzpes
	mov	byte ptr [Mem+bx],z
	dec	bl
	mov	bp,bx
	endm
pulloff	macro	z		;pull z off stack
	mov	bx,bp
	inc	bl
	mov	bp,bx
	loadzpes
	mov	z,byte ptr [Mem+bx]
	endm
setovf	macro			;set overflow flag
	LOCAL	@oo1
	and	flags,not overflow
	sahf
	jno	@oo1
	or	flags,overflow
@oo1:
	endm
scf	macro	op,z,isbh0	;save carry flag
	LOCAL	@scf1
	sahf
	jc	@scf1
	op	acc,z
	lahf
	Cycle	isbh0
@scf1:	op	acc,z
	stc
	lahf
	Cycle	isbh0
	endm
lodreg	macro	reg		;load register
	mov	reg,word ptr [si]
	add	si,2
	endm

;	DECIMAL MODE ROUTINEZ

setopc	macro	opc,adr		;set opcode <opc> to point to <adr>
	mov	word ptr opcodes[opc*2],offset adr
	endm

DoDecMode:
	test	flags,decmode
	jz	NotDecMode
	cmp	word ptr opcodes[69h*2],offset @69dec
	je	DecModeRet
	setopc	69h,@69dec
	setopc	65h,@65dec
	setopc	75h,@75dec
	setopc	6dh,@6ddec
	setopc	7dh,@7ddec
	setopc	79h,@79dec
	setopc	61h,@61dec
	setopc	71h,@71dec
	setopc	0e9h,@e9dec
	setopc	0e5h,@e5dec
	setopc	0f5h,@f5dec
	setopc	0edh,@eddec
	setopc	0fdh,@fddec
	setopc	0f9h,@f9dec
	setopc	0e1h,@e1dec
	setopc	0f1h,@f1dec
DecModeRet:
        ret
NotDecMode:
	cmp     word ptr opcodes[69h*2],offset @69
	je	DecModeRet
	setopc	69h,@69
	setopc	65h,@65
	setopc	75h,@75
	setopc	6dh,@6d
	setopc	7dh,@7d
	setopc	79h,@79
	setopc	61h,@61
	setopc	71h,@71
	setopc	0e9h,@e9
	setopc	0e5h,@e5
	setopc	0f5h,@f5
	setopc	0edh,@ed
	setopc	0fdh,@fd
	setopc	0f9h,@f9
	setopc	0e1h,@e1
	setopc	0f1h,@f1
	ret

PURGE	setopc

;		*** AND NOW THE INSTRUCTIONS
;		*** IN ALPHABETICAL ORDER

addovf	macro	dest
	LOCAL	@oo1
	and	flags,not overflow
	sahf
	adc	acc,dest
	lahf
	jno	@oo1
	or	flags,overflow
@oo1:
	endm

@69:		; adc #aa
	getimm
	addovf	al
	Cycle	bh0
@69dec:
	getimm
	sahf
	adc	al,acc
	daa
	lahf
	setovf
	mov	acc,al
	jmp	cycl

@65:		; adc aa
	getzp	bh0
	addovf	[Mem+bx]
	Cycle	bh0
@65dec:
	getzp	bh0
@DecModeBX:
	sahf
	mov	al,acc
	adc	al,[Mem+bx]
	daa
	lahf
	setovf
	mov	acc,al
	jmp	cycl

@75:		; adc aa,x
	getzpx	bh0
	addovf	[Mem+bx]
	Cycle2	bh0
@75dec:
	getzpx	bh0
	jmp	@DecModeBX

@6d:		; adc aaaa
	getabs
	ifio	<addovf	[Mem+bx]>
	Cycle
@6Ddec:
	getabs
	jmp	@DecModeBX

@7d:		; adc aaaa,x
	getabsx
	ifio	<addovf	[Mem+bx]>
	Cycle2
@7Ddec:
	getabsx
	jmp	@DecModeBX

@79:		; adc aaaa,y
	getabsy
	ifio	<addovf	[Mem+bx]>
	Cycle2
@79dec:
	getabsy
	jmp	@DecModeBX

@61:		; adc (aa,x)
	getindx	bh0
	ifio	<addovf	[Mem+bx]>
	Cycle2
@61dec:
	getindx	bh0
	jmp	@DecModeBX

@71:		; adc (aa),y
	getindy	bh0
	ifio	<addovf	[Mem+bx]>
	Cycle
@71dec:
	getindy	bh0
	jmp	@DecModeBX

@72:		; adc (aa) (65C02 only)
	getind	bh0
	addovf	[Mem+bx]
	Cycle2
@72dec:
	getind	bh0
	jmp	@DecModeBX

PURGE addovf

@29:		; and #aa
	getimm
	scf     and,al,bh0

@25:		; and aa
	getzp	bh0
	scf	and,[Mem+bx],bh0

@35:		; and aa,x
	getzpx	bh0
	scf	and,[Mem+bx],bh0

@2d:		; and aaaa
	getabs
	ifio	<scf	and,[Mem+bx]>

@3d:		; and aaaa,x
	getabsx
	ifio	<scf	and,[Mem+bx]>

@39:		; and aaaa,y
	getabsy
	ifio	<scf	and,[Mem+bx]>

@21:		; and (aa,x)
	getindx	bh0
	ifio	<scf	and,[Mem+bx]>

@31:		; and (aa),y
	getindy	bh0
	ifio	<scf	and,[Mem+bx]>

@32:		; and (aa) (65C02 only)
	getind	bh0
	ifio	<scf	and,[Mem+bx]>

@a:		; asl a
	sahf
	shl	acc,1
	lahf
	Cycle	bh0

@6:		; asl aa
	getzp	bh0
	sahf
	shl	byte ptr [Mem+bx],1
	lahf
	Cycle	bh0

@16:		; asl aa,x
	getzpx	bh0
	sahf
	shl	byte ptr [Mem+bx],1
	lahf
	Cycle2	bh0

@e:		; asl aaaa
	getabs	<shl byte ptr [Mem+bx],1>,flag
	Cycle

@1e:		; asl aaaa,x
	getabsx	<shl byte ptr [Mem+bx],1>,flag
	Cycle2

branch	macro	z,isbh0		;if z, branch
	LOCAL	nobranch
	getimm
	z	nobranch
	mov	bl,ah
	cbw
	add	si,ax
;	loadnewip
	mov	ah,bl
nobranch:
	Cycle	<isbh0>
	endm

@90:		; bcc
	sahf
	branch	jc

@b0:		; bcs
	sahf
	branch	jnc

@f0:		; beq
	sahf
	branch	jne

@30:		; bmi
	sahf
	branch	jns,bh0

@d0:		; bne
	sahf
	branch	je

@10:		; bpl
	sahf
	branch	js,bh0

@50:		; bvc
	test	flags,overflow
	branch	jnz,bh0

@70:		; bvs
	test	flags,overflow
	branch	jz,bh0

@80:		; bra (65C02 only)
	branch  <;>

bitop	macro
	LOCAL	@bit_1,@bit_2,@bit_3
	mov	al,[Mem+bx]
	and	ah,not (040h+080h)
	and	flags,not overflow
	test	al,64
	jz	@bit_1
	or	flags,overflow		;overflag flag
@bit_1:	or	al,al
	jns	@bit_3
	or	ah,080h		;set sign flag
@bit_3:	test	acc,al
	jnz	@bit_2
	or	ah,040h		;set zero flag
@bit_2:
	endm

@89:		; bit #aa (65C02 only)
	mov	bx,si
	inc	si
	bitop
	Cycle

@24:		; bit aa
	getzp	bh0
	bitop
	Cycle

@34:		; bit aa,x (65C02 only)
	getzpx	bh0
	bitop
	Cycle

@2c:		; bit aaaa
	getabs
	ifio	<bitop>

@3c:		; bit aaaa,x (65C02 only)
	getabs
	ifio	<bitop>

	PURGE	branch,bitop

@0:		; brk
	push	cx
	mov	cx,si
	add	si,2
	pushon	ch
	pushon	cl
	pop	cx
	mov	bl,ah
	rol	bl,1
	rol	bl,1
	and	bx,7
	mov	al,phptbl[bx]
	or	flags,breakflag
	or	al,flags
	pushon	al
IFDEF langram
	mov	es,[RdMemMap+0feh]
ENDIF
	mov	si,[Mem+IRQvector]
	loadnewip
	jmp	cycl

@18:		; clc
	and	ah,254
	Cycle	bh0

@d8:		; cld
	and	flags,not decmode
	call	DoDecMode
	jmp	cycl

@58:		; cli
	and	flags,not irqdisable
	Cycle2	bh0

@b8:		; clv
	and	flags,not overflow
	Cycle2

compar	macro	reg,mem
	sahf
	cmp	reg,mem
	cmc
	lahf
	endm

@c9:		; cmp #aa
	getimm
	compar	acc,al
	Cycle

@c5:		; cmp aa
	getzp
	compar	acc,[Mem+bx]
	Cycle	bh0

@d5:		; cmp aa,x
	getzpx
	compar	acc,[Mem+bx]
	Cycle2

@cd:		; cmp aaaa
	getabs
	ifio	<compar	acc,[Mem+bx]>

@dd:		; cmp aaaa,x
	getabsx
	ifio	<compar	acc,[Mem+bx]>

@d9:		; cmp aaaa,y
	getabsy
	ifio	<compar	acc,[Mem+bx]>

@c1:		; cmp (aa,x)
	getindx
	ifio	<compar	acc,[Mem+bx]>

@d1:		; cmp (aa),y
	getindy
	ifio	<compar	acc,[Mem+bx]>

@d2:		; cmp (aa) (65C02 only)
	getind
	ifio	<compar	acc,[Mem+bx]>

@e0:		; cpx #aa
	getimm
	compar	x,al
	Cycle

@e4:		; cpx aa
	getzp
	compar	x,[Mem+bx]
	Cycle	bh0

@ec:		; cpx aaaa
	getabs
	ifio	<compar	x,[Mem+bx]>

@c0:		; cpy #aa
	getimm
	compar	y,al
	Cycle

@c4:		; cpy aa
	getzp
	compar	y,[Mem+bx]
	Cycle	bh0

@cc:		; cpy aaaa
	getabs
	ifio	<compar	y,[Mem+bx]>

@3a:		; dec A (65C02 only)
	sahf
	dec	acc
	lahf
	Cycle	bh0

@c6:		; dec aa
	getzp
	sahf
	dec	byte ptr [Mem+bx]
	lahf
	Cycle	bh0

@d6:		; dec aa,x
	getzpx
	sahf
	dec	byte ptr [Mem+bx]
	lahf
	Cycle2

@ce:		; dec aaaa
	getabs	<dec byte ptr [Mem+bx]>,flag
	Cycle

@de:		; dec aaaa,x
	getabsx	<dec byte ptr [Mem+bx]>,flag
        Cycle

@ca:		; dex
	sahf
	dec	x
	lahf
	Cycle

@88:		; dey
	sahf
	dec	y
	lahf
	Cycle

@49:		; eor #aa
	getimm
	scf	xor,al,bh0

@45:		; eor aa
	getzp	bh0
	scf	xor,[Mem+bx],bh0

@55:		; eor aa,x
	getzpx	bh0
	scf	xor,[Mem+bx],bh0

@4d:		; eor aaaa
	getabs
	ifio	<scf	xor,[Mem+bx]>

@5d:		; eor aaaa,x
	getabsx
	ifio	<scf	xor,[Mem+bx]>

@59:		; eor aaaa,y
	getabsy
	ifio	<scf	xor,[Mem+bx]>

@41:		; eor (aa,x)
	getindx	bh0
	ifio	<scf	xor,[Mem+bx]>

@51:		; eor (aa),y
	getindy	bh0
	ifio	<scf	xor,[Mem+bx]>

@52:		; eor (aa) (65C02 only)
	getind	bh0
	ifio	<scf	xor,[Mem+bx]>

@1a:		; inc A (65C02 only)
	sahf
	inc	acc
	lahf
	Cycle	bh0

@e6:		; inc aa
	getzp
	sahf
	inc	byte ptr [Mem+bx]
	lahf
	Cycle	bh0

@f6:		; inc aa,x
	getzpx
	sahf
	inc	byte ptr [Mem+bx]
	lahf
	Cycle2

@ee:		; inc aaaa
	getabs	<inc byte ptr [Mem+bx]>,flag
	Cycle

@fe:		; inc aaaa,x
	getabsx	<inc byte ptr [Mem+bx]>,flag
	Cycle

@e8:		; inx
	sahf
	inc	x
	lahf
	Cycle

@c8:		; iny
	sahf
	inc	y
	lahf
	Cycle

@4c:		; jmp aaaa
	mov	si,[si]
	loadnewip
IFDEF langram
	Cycle
ELSE
	Cycle	bh0
ENDIF

@6c:            ; jmp (aaaa)
	mov	bx,[si]
IFDEF langram
	mov	al,bh
	mov	di,ax
	and	di,0feh
	mov	es,RdMemMap[di]
ENDIF
	mov     si,[Mem+bx]
        inc     bl
        xchg    si,bx
	mov     bh,[Mem+si]
	mov     si,bx
IFDEF langram
	mov	bl,bh
	and	bx,0feh
	mov	ds,[RdMemMap+bx]
ENDIF
        Cycle
;       mov     si,[Mem+si]         ;correction for 65C02
;	mov	si,[Mem+si]
;	Cycle	bh0

@7c:		; jmp (aaaa,x) (65C02 only)
	getabsx
	mov	si,[Mem+bx]
	loadnewip
	Cycle

@20:		; jsr aaaa
	loadzpes
	cmp	bp,102h
	jb	jsr2
	inc	si
	mov	word ptr [Mem+bp-1],si
	sub	bp,2
	mov	si,[si-1]
	loadnewip
IFDEF langram
	Cycle
ELSE
	Cycle	bh0
ENDIF
jsr2:
	push	ax
	mov	ax,si
	inc	ax
	mov	bx,bp
	mov	byte ptr [Mem+bx],ah
	dec	bl
	mov	byte ptr [Mem+bx],al
	dec	bl
	mov	bp,bx
	mov	si,[si]
	loadnewip
	pop	ax
	jmp	cycl

@a9:		; lda #aa
	getimm
	mov	acc,al
	sahf
	inc	al
	dec	al
	lahf
	Cycle

@a5:		; lda aa
	getzp
	movor	acc
	Cycle	bh0

@b5:		; lda aa,x
	getzpx
	movor	acc
	Cycle	bh0

@ad:		; lda aaaa
	getabs
	ifio	<movor acc>

@bd:		; lda aaaa,x
	getabsx
	ifio	<movor acc>

@b9:		; lda aaaa,y
	getabsy
	ifio	<movor acc>

@a1:		; lda (aa,x)
	getindx
	ifio	<movor acc>

@b1:		; lda (aa),y
	getindy
	ifio	<movor acc>

@b2:		; lda (aa) (65C02 only)
	getind
	ifio	<movor acc>

@a2:		; ldx #aa
	getimm
	mov	x,al
	sahf
	inc	x
	dec	x
	lahf
	Cycle

@a6:		; ldx aa
	getzp
	movor	x
	Cycle	bh0

@b6:		; ldx aa,y
	getzpy
	movor	x
	Cycle2

@ae:		; ldx aaaa
	getabs
	ifio	<movor x>

@be:		; ldx aaaa,y
	getabsy
	ifio	<movor x>

@a0:		; ldy #aa
	getimm
	mov	y,al
	sahf
	inc	y
	dec	y
	lahf
	Cycle

@a4:		; ldy aa
	getzp
	movor	y
	Cycle	bh0

@b4:		; ldy aa,x
	getzpx
	movor	y
	Cycle2

@ac:		; ldy aaaa
	getabs
	ifio	<movor y>

@bc:		; ldy aaaa,x
	getabsx
	ifio	<movor y>

@4a:		; lsr A
	sahf
	shr	acc,1
	lahf
	Cycle	bh0

@46:		; lsr aa
	getzp	bh0
	sahf
	shr	byte ptr [Mem+bx],1
	lahf
	Cycle	bh0

@56:		; lsr aa,x
	getzpx	bh0
	sahf
	shr	byte ptr [Mem+bx],1
	lahf
	Cycle2	bh0

@4e:		; lsr aaaa
	getabs	<shr byte ptr [Mem+bx],1>,flag
	Cycle

@5e:		; lsr aaaa,x
	getabsx	<shr byte ptr [Mem+bx],1>,flag
	Cycle2

@ea	equ	cycl	;nop

@9:		; ora #aa
	getimm
	scf	or,al,bh0

@5:		; ora aa
	getzp	bh0
	scf	or,[Mem+bx],bh0

@15:		; ora aa,x
	getzpx	bh0
	scf	or,[Mem+bx],bh0

@d:		; ora aaaa
	getabs
	ifio	<scf or,[Mem+bx]>

@1d:		; ora aaaa,x
	getabsx
	ifio	<scf or,[Mem+bx]>

@19:		; ora aaaa,y
	getabsy
	ifio	<scf or,[Mem+bx]>

@1:		; ora (aa,x)
	getindx	bh0
	ifio	<scf or,[Mem+bx]>

@11:		; ora (aa),y
	getindy	bh0
	ifio	<scf or,[Mem+bx]>

@12:		; ora (aa) (65C02 only)
	getind	bh0
	ifio	<scf or,[Mem+bx]>

@48:		; pha
	pushon	acc
	Cycle

@8:		; php
	mov	bl,ah
	rol	bl,1
	rol	bl,1
	and	bl,7
	mov	al,phptbl[bx]
	or	al,flags
	pushon	al
	Cycle

@da:		; phx (65C02 only)
	pushon	x
	Cycle

@5a:		; phy (65C02 only)
	pushon	y
	Cycle

@68:		; pla
	pulloff	acc
	sahf
	inc	acc
	dec	acc
	lahf
	Cycle

@fa:		; plx (65C02 only)
	pulloff	x
	sahf
	inc	x
	dec	x
	lahf
	Cycle

@7a:		; ply (65C02 only)
	pulloff	y
	sahf
	inc	y
	dec	y
	lahf
	Cycle

@28:		; plp
	pulloff	flags
	mov	bl,flags
	and	flags,allflags
	or	flags,orflags
	rol	bl,1
	and	bx,7
	mov	ah,plptbl[bx]
	call	DoDecMode
	Cycle2

rotate	macro	oper
	mov	al,[Mem+bx]
	sahf
	oper	al,1
	inc	al
	dec	al
	lahf
	mov	[Mem+bx],al
	endm

@2a:		; rol A
	sahf
	rcl	acc,1
	inc	acc
	dec	acc
	lahf
	Cycle	bh0

@26:		; rol aa
	getzp	bh0
	rotate	rcl
	Cycle	bh0

@36:		; rol aa,x
	getzpx	bh0
	rotate	rcl
	Cycle2	bh0

@2e:		; rol aaaa
	getabs	<rotate rcl>
;	rotate	rcl
	Cycle

@3e:		; rol aaaa,x
	getabsx	<rotate rcl>
;	rotate	rcl
	Cycle2

@6a:		; ror A
	sahf
	rcr	acc,1
	inc	acc
	dec	acc
	lahf
	Cycle	bh0

@66:		; ror aa
	getzp	bh0
	rotate	rcr
	Cycle	bh0

@76:		; ror aa,x
	getzpx	bh0
	rotate	rcr
	Cycle2	bh0

@6e:		; ror aaaa
	getabs	<rotate rcr>
;	rotate	rcr
	Cycle

@7e:		; ror aaaa,x
	getabsx	<rotate rcr>
;	rotate	rcr
	Cycle2

PURGE	rotate

@40:		; rti
	pulloff	flags
	pulloff	al
	pulloff	ah
	mov	si,ax
	mov	bl,flags
	and	flags,allflags
	rol	bl,1
	and	bx,7
	mov	ah,plptbl[bx]
	call	DoDecMode
	loadnewip
	jmp	cycl

@60:		; rts
	loadzpes
	cmp	bp,1fdh
	ja	rts2
	mov	si,word ptr [Mem+bp+1]
	add	bp,2
	inc	si
	loadnewip
IFDEF langram
	Cycle
ELSE
	Cycle	bh0
ENDIF
rts2:
	push	ax
	mov	bx,bp
	inc	bl
	mov	al,byte ptr [Mem+bx]
	inc	bl
	mov	ah,byte ptr [Mem+bx]
	inc	ax
	mov	si,ax
	loadnewip
	pop	ax
	jmp	cycl

subovf	macro	dest
	LOCAL	@oo1
	and	flags,not overflow
	sahf
	cmc
	sbb	acc,dest
	cmc
	lahf
	jno	@oo1
	or	flags,overflow
@oo1:
	endm

@e9:		; sbc #aa
	getimm
	subovf	al
	Cycle
@e9dec:
	sahf
	cmc
	sbb	acc,[si]
	mov	al,acc
	das
	mov	acc,al
	cmc
	lahf
	setovf
	inc	si
	jmp	cycl

@e5:		; sbc aa
	getzp
	subovf	[Mem+bx]
	Cycle	bh0
@e5dec:
	getzp
@DecSubBX:
	sahf
	cmc
	mov	al,acc
	sbb	al,[Mem+bx]
	das
	mov	acc,al
	cmc
	lahf
	setovf
	jmp	cycl

@f5:		; sbc aa,x
	getzpx
	subovf	[Mem+bx]
	Cycle2
@f5dec:
	getzpx
	jmp	@DecSubBX

@ed:		; sbc aaaa
	getabs
	ifio	<subovf	[Mem+bx]>
	Cycle
@eddec:
	getabs
	jmp	@DecSubBX

@fd:		; sbc aaaa,x
	getabsx
	ifio	<subovf	[Mem+bx]>
	Cycle2
@fddec:
	getabsx
	jmp	@DecSubBX

@f9:		; sbc aaaa,y
	getabsy
	ifio	<subovf	[Mem+bx]>
	Cycle2
@f9dec:
	getabsy
	jmp	@DecSubBX

@e1:		; sbc (aa,x)
	getindx
	ifio	<subovf	[Mem+bx]>
	Cycle2
@e1dec:
	getindx
	jmp	@DecSubBX

@f1:		; sbc (aa),y
	getindy
	ifio	<subovf	[Mem+bx]>
	Cycle
@f1dec:
	getindy
	jmp	@DecSubBX

@f2:		; sbc (aa) (65C02 only)
	getind
	ifio	<subovf	[Mem+bx]>
	Cycle
@f2dec:
	getind
	jmp	@DecSubBX

PURGE subovf

@38:		; sec
	or	ah,1
	Cycle	bh0

@f8:		; sed
	or	flags,decmode
	call	DoDecMode
	jmp	cycl

@78:		; sei
	or	flags,irqdisable
	Cycle2	bh0

@85:		; sta aa
	getzp
	mov	[Mem+bx],acc
	Cycle	bh0

@95:		; sta aa,x
	getzpx
	mov	[Mem+bx],acc
	Cycle2

@8d:		; sta aaaa
	getabs	<mov [Mem+bx],acc>

@9d:		; sta aaaa,x
	getabsx	<mov [Mem+bx],acc>

@99:		; sta aaaa,y
	getabsy	<mov [Mem+bx],acc>

@81:		; sta (aa,x)
	getindx	<>,<mov [Mem+bx],acc>

@91:		; sta (aa),y
	getindy	<>,<mov [Mem+bx],acc>

@92:		; sta (aa) (65C02 only)
	getind	<>,<mov [Mem+bx],acc>

@86:		; stx aa
	getzp
	mov	[Mem+bx],x
	Cycle	bh0

@96:		; stx aa,y
	getzpy
	mov	[Mem+bx],x
	Cycle2

@8e:		; stx aaaa
	getabs	<mov [Mem+bx],x>

@84:		; sty aa
	getzp
	mov	[Mem+bx],y
	Cycle	bh0

@94:		; sty aa,x
	getzpx
	mov	[Mem+bx],y
	Cycle2

@8c:		; sty aaaa
	getabs	<mov [Mem+bx],y>

@64:		; stz aa (65C02 only)
	getzp
	mov	[Mem+bx],bh		;bh is zero
	Cycle   bh0

@74:		; stz aa,x (65C02 only)
	getzpx
	mov	[Mem+bx],bh		;bh is zero
	Cycle	bh0

@aa:		; tax
	mov	x,acc
	sahf
	inc	x
	dec	x
	lahf
	Cycle

@a8:		; tay
	mov	y,acc
	sahf
	inc	y
	dec	y
	lahf
	Cycle

testbit	macro	oper,src
	LOCAL	@tnc
	oper	[Mem+bx],src
	jz	@tnc
	and	ah,not 40h
	jmp	cycl
@tnc:	or	ah,40h
	jmp	cycl
	endm

@14:		; trb aa (65C02 only)
	getzp
	mov	al,acc
	not	al
	testbit	and,al

@1c:		; trb aaaa (65C02 only)
	getabs
	mov	al,acc
	not	al
	testbit and,al

@04:		; tsb aa (65C02 only)
	getzp
	testbit	or,acc

@0c:		; tsb aaaa (65C02 only)
	getabs
	testbit or,acc

PURGE testbit

@ba:		; tsx
	mov	bx,bp
	mov	x,bl
	sahf
	inc	x
	dec	x
	lahf
	Cycle

@8a:		; txa
	mov	acc,x
	sahf
	inc	acc
	dec	acc
	lahf
	Cycle

@9a:		; txs
	mov	bl,x
	mov	bh,1
	mov	bp,bx
	Cycle

@98:		; tya
	mov	acc,y
	sahf
	inc	acc
	dec	acc
	lahf
	Cycle

