program Sim6502;
{$A+,R-,S-,Q-,G+}
{$M $2000,$16001,$16001}
{ $DEFINE CGA}
uses CRT, Win, WDLib, EditPay, Dos;

const
  NumDrives = 2;
  PdlInst : array[0..3] of byte = ($37,$73,$5,$60);

type
  IOBtype = record
    tabletype,slot,drive,volume,track,sector : byte;
    DCB,buffer : word;
    unused : byte;
    bytecount,commandcode,returncode : byte;
    lastvol,lastslot,lastdrive : byte;
  end;
  IOBptr = ^IOBtype;
  BigBuf = array[0..$fffe] of byte;
  PageType = array[0..$2fff] of byte;
  RWTSbufType = array[0..255] of byte;

var
  MemSeg : ^BigBuf;
  RomPage,LangPage : pointer;
  CGAbuf : pointer;
  Old_Int9 : pointer;

  disk : array[1..NumDrives] of file;
  diskopen : array[1..NumDrives] of boolean;
  rwtsbuf : RWTSbufType;

procedure Process; external;
procedure Int9Rtn; interrupt; external;
procedure StoreByte(val,adr : word); external;
{$IFDEF CGA}
procedure CGAlkup; external;
{$ENDIF}

{$L 6502.OBJ}

var Nybl : array[0..$1900] of byte;
    NyblPtr, NumNybls : word;
    NyblTrack : byte;
    DirtyTrack : boolean;
const NyblWriteTbl : array[0..$3F] of byte =
  ($96,$97,$9A,$9B,$9D,$9E,$9F,$A6,$A7,$AB,$AC,$AD,$AE,$AF,$B2,$B3,
   $B4,$B5,$B6,$B7,$B9,$BA,$BB,$BC,$BD,$BE,$BF,$CB,$CD,$CE,$CF,$D3,
   $D6,$D7,$D9,$DA,$DB,$DC,$DD,$DE,$DF,$E5,$E6,$E7,$E9,$EA,$EB,$EC,
   $ED,$EE,$EF,$F2,$F3,$F4,$F5,$F6,$F7,$F9,$FA,$FB,$FC,$FD,$FE,$FF);

procedure WriteNybl(n : byte);
begin
  Nybl[NyblPtr] := n; inc(NyblPtr);
end;
procedure WriteSync(num : word);
begin
  while num > 0 do begin WriteNybl($FF); dec(num) end;
end;
procedure OddEven(n : byte);
begin
  WriteNybl((n shr 1) or $AA);
  WriteNybl(n or $AA);
end;

procedure FlushTrack;
begin
  DirtyTrack := false;
end;

procedure MakeNibbles; interrupt;
const volume = $FE;
      d = 1;
      Skew : array[0..15] of byte =
        (0,7,14,6,13,5,12,4,11,3,10,2,9,1,8,15);
var sect : byte;
    i,j : integer;
    track,a,chksum : byte;
    result : word;
    Buf : array[0..15] of RWTSbufType;
procedure Encode(n : byte);
begin
  WriteNybl(NyblWriteTbl[n xor chksum]);
  chksum := n;
end;
function lsr(n : byte) : byte;
begin
  lsr := (n and 1) shl 1 + (n and 2) shr 1;
end;

begin
  if DirtyTrack then FlushTrack;
  track := NyblTrack shr 1;
{  directvideo := false;
  gotoxy(1,25); textattr := Cyan; write(track:3);}
  NyblPtr := 0;
  FillChar(nybl,sizeof(nybl),0);
  Seek(disk[d],longint(track)*16*256);
  BlockRead(disk[d],Buf,$1000,result);
  WriteSync(40);
  for j := 0 to 15 do begin
    sect := j;
{    seek(disk[d],longint(Skew[sect]+track*16)*256);
    blockread(disk[d],rwtsbuf,256,result);}
    rwtsbuf := Buf[Skew[sect]];
    WriteNybl($D5); WriteNybl($AA); WriteNybl($96);
    OddEven(volume); OddEven(track); OddEven(sect);
    OddEven(volume xor track xor sect);
    WriteNybl($DE); WriteNybl($AA); WriteNybl($EB);
    WriteSync(5);
    WriteNybl($D5); WriteNybl($AA); WriteNybl($AD);
    chksum := 0;
    for i := 0 to 85 do begin
      a := lsr(rwtsbuf[i]) + lsr(rwtsbuf[i+86]) shl 2;
      if i < 84 then a := a + lsr(rwtsbuf[i+172]) shl 4;
      Encode(a);
    end;
    for i := 0 to 255 do Encode(rwtsbuf[i] shr 2);
    Encode(0); { checksum }
    WriteNybl($DE); WriteNybl($AA); WriteNybl($EB);
    WriteSync(14);
  end;
  NumNybls := NyblPtr;
  NyblPtr := 0;
end;

{procedure StatusLine;
const dx : array[1..2] of byte = (1,41);
var
  drv : byte;
  D: DirStr;
  N: NameStr;
  E: ExtStr;
begin
  for drv := 1 to 2 do begin
    FSplit(FileRec(Disk[drv]).Name, D, N, E);
    WriteStr(dx[drv],25,Blanks(3)+Spaces(D[1]+':'+N, 40-3), Cyan*16);
  end;
end;}

function RWTS(iob : IOBptr) : integer;
var i,d,bcount,result : integer;
    bf : ^RWTSbufType;
begin
 {$I-}
 RWTS := $40;
 with iob^ do begin
  ReturnCode := $40;
  d := drive;

  if (tabletype <> 1) or (slot <> $60) or (d = 0) or (d > NumDrives) or
    (commandcode > 4) or not DiskOpen[d] then Exit;
  if (track > 34) or (sector > 15) then Exit;
  if (commandcode < 3) then
    seek(disk[d],longint(sector+track*16)*256);
  if IOresult > 0 then Exit;

  bf := ptr(seg(MemSeg^),buffer);
  bcount := 256; result := bcount;
  case commandcode of
    0 : begin end;
    1 : begin
          blockread(disk[d],rwtsbuf,bcount,result);
          for i := 0 to 255 do
            STOREBYTE(buffer+i,rwtsbuf[i]);
        end;
    2 : begin
      blockwrite(disk[d],bf^,bcount,result);
    end;
    else result := 0;
  end;
  if result <> bcount then Exit;
  lastvol := volume;
  lastslot := slot;
  lastdrive := drive;
  RWTS := 0;
  ReturnCode := 0;
 end;
 {$I+}
end;

procedure GetCmem(var p : pointer; size : word);
begin
  GetMem(p,size);
  FillChar(p^,size,0);
end;

procedure SetupMem;
var f : file;
    p : pointer;
    i : integer;
begin
  if (MaxAvail < $10001) then begin
    writeln('Not enough memory.'); Halt; end;

  while ofs(HeapPtr^) and 15 > 0 do GetMem(p,1);
  GetCmem(pointer(MemSeg),$FFFF); GetCmem(p,1);
{  GetMem(RomPage,$3000);}
  GetCmem(LangPage,$4000);

  assign(f,'rom.dat');
  reset(f,1);
  blockread(f,MemSeg^[$D000],$3000);
  close(f);
  if diskopen[1] then begin
    assign(f,'daboot.dat');
    reset(f,1);
    blockread(f,MemSeg^[$C600],$100);
    close(f);
  end;
{$IFNDEF CGA}
  assign(f,'hires.bit');
  reset(f,1);
  Inline($b8/$D/$0/$cd/$10);
  portw[$3ce] := $5;
  for i := 0 to 3 do begin
    port[$3c4] := 2; port[$3c5] := 1 shl i;
    blockread(f,mem[$a000:$4000],$2000);
  end;
{$ELSE}
  assign(f,'hires.cga');
  reset(f,1);
  BlockRead(f, ptr(seg(CGAlkup),ofs(CGAlkup))^, $1000);
{$ENDIF}
  close(f);
end;

procedure SetInterrupts;
var a : byte;
begin
  GetIntVec($9, Old_Int9);
  SetIntVec($9, @Int9Rtn);
{  Port[$21] := Port[$21] or 1;}
end;

procedure ClearInterrupts;
begin
{  Port[$21] := Port[$21] and (not 1);}
  SetIntVec($9, Old_Int9);
end;

function OpenDisk(drive : byte; path : string) : boolean;
begin
  {$I-}
  assign(disk[drive],path);
  reset(disk[drive],1);
  if IOresult = 0 then begin
    OpenDisk := true;
    diskopen[drive] := true;
    NyblTrack := $FF;
  end else begin
    OpenDisk := false;
  end;
  {$I+}
end;

procedure CloseDisk(drive : byte);
begin
  if diskopen[drive] then begin
    close(disk[drive]);
    diskopen[drive] := false;
  end;
end;

procedure PROGMENU; interrupt;
const OnOff : array[boolean] of string[3] = ('on','off');
var s : string[80];
    tc : char;
    Mprog : MenuRec;
    sel : byte;
begin
  ClearInterrupts;
  DirectVideo := false;
  SetCursorOff;
  Menu_Init(Mprog, 20, 12, 'Apple ][ Menu');
  Menu_AddHotKey(Mprog, 'Open disk in drive 1', 18);
  Menu_AddHotKey(Mprog, 'Open disk in drive 2', 18);
  Menu_Add(Mprog, 'Sound '+OnOff[NOT (MemSeg^[$c030] and 1 > 0)]);
  sel := Menu_Sel(Mprog);
  case sel of
    1,2 : begin
      Win_Open(7,11,33,13,'Enter filename', FieldsCol, 0);
      s := '';
      EditLine(s,20,2,1,[#32..#127],[Esc,CR],AllUppers);
      Win_Close;
      if (TC <> Esc) and (s <> '') then begin
        closedisk(sel);
        if Pos('.',s) = 0 then s := s + '.dsk';
        if not opendisk(sel, s) then ;
      end;
    end;
    3 : begin
      MemSeg^[$c030] := MemSeg^[$c030] xor 1;
    end;
  end;
  Menu_Delete(Mprog);
  GotoXY(1, 25);
  ClrEol;
  GotoXY(1, 50);
  SetInterrupts;
end;

var i : integer;
begin
  Inline($90);
  FillChar(DiskOpen,sizeof(DiskOpen),0);
  if (ParamCount > 0) then begin
    for i := 1 to ParamCount do begin
      if not OpenDisk(i, ParamStr(i)+'.dsk') then begin
        Writeln('Could not open "',ParamStr(i)+'.dsk','".');
        Halt;
      end;
    end;
  end else begin
    Writeln('USAGE: 6502 <drive1>[.dsk] [drive2][.dsk]');
    Halt;
  end;
  SetupMem;
  NyblTrack := 255;
{  MakeNibbles(1,0);}
  WinSetup;
{  memseg^[$c030] := 1;}
  SetInterrupts;
  PROCESS;
  ClearInterrupts;
  for i := 1 to NumDrives do
    if DiskOpen[i] then CloseDisk(i);
end.
